/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.polylines;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.polylines.Polyline;
import com.eegeo.mapapi.polylines.PolylineOptions;
import java.security.InvalidParameterException;
import java.util.List;

public class PolylineApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<Polyline> m_nativeHandleToPolyline = new SparseArray();

    public PolylineApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void register(Polyline polyline, Polyline.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToPolyline.put(polyline.getNativeHandle(allowHandleAccess), (Object)polyline);
    }

    private double[] pointsToArray(List<LatLng> points) {
        int pointCount = points.size();
        double[] coords = new double[pointCount * 2];
        for (int i = 0; i < pointCount; ++i) {
            coords[i * 2] = points.get((int)i).latitude;
            coords[i * 2 + 1] = points.get((int)i).longitude;
        }
        return coords;
    }

    @WorkerThread
    public int create(PolylineOptions polylineOptions, Polyline.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polyline");
        }
        if (polylineOptions.getPoints().size() < 2) {
            throw new InvalidParameterException("PolylineOptions points must contain at least two elements");
        }
        double[] latLongs = this.pointsToArray(polylineOptions.getPoints());
        return this.nativeCreatePolyline(this.m_jniEegeoMapApiPtr, polylineOptions.getIndoorMapId(), polylineOptions.getIndoorFloorId(), polylineOptions.getElevation(), polylineOptions.getElevationMode().ordinal(), latLongs, polylineOptions.getWidth(), polylineOptions.getColor(), polylineOptions.getMiterLimit());
    }

    @WorkerThread
    public void destroy(Polyline polyline, Polyline.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polyline");
        }
        int nativeHandle = polyline.getNativeHandle(allowHandleAccess);
        if (this.m_nativeHandleToPolyline.get(nativeHandle) != null) {
            this.nativeDestroyPolyline(this.m_jniEegeoMapApiPtr, nativeHandle);
            this.m_nativeHandleToPolyline.remove(nativeHandle);
        }
    }

    @WorkerThread
    void setIndoorMap(int nativeHandle, Polyline.AllowHandleAccess allowHandleAccess, String indoorMapId, int indoorFloorId) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polyline");
        }
        this.nativeSetIndoorMap(this.m_jniEegeoMapApiPtr, nativeHandle, indoorMapId, indoorFloorId);
    }

    @WorkerThread
    void setElevation(int nativeHandle, Polyline.AllowHandleAccess allowHandleAccess, double elevation, ElevationMode elevationMode) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polyline");
        }
        this.nativeSetElevation(this.m_jniEegeoMapApiPtr, nativeHandle, elevation, elevationMode.ordinal());
    }

    @WorkerThread
    void setStyleAttributes(int nativeHandle, Polyline.AllowHandleAccess allowHandleAccess, float width, int colorARGB, float miterLimit) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Polyline");
        }
        this.nativeSetStyleAttributes(this.m_jniEegeoMapApiPtr, nativeHandle, width, colorARGB, miterLimit);
    }

    @WorkerThread
    private native int nativeCreatePolyline(long var1, String var3, int var4, double var5, int var7, double[] var8, float var9, int var10, float var11);

    @WorkerThread
    private native void nativeDestroyPolyline(long var1, int var3);

    @WorkerThread
    private native void nativeSetIndoorMap(long var1, int var3, String var4, int var5);

    @WorkerThread
    private native void nativeSetElevation(long var1, int var3, double var4, int var6);

    @WorkerThread
    private native void nativeSetStyleAttributes(long var1, int var3, float var4, int var5, float var6);
}

