/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.services.mapscene;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.services.mapscene.Mapscene;
import com.eegeo.mapapi.services.mapscene.MapsceneApplier;
import com.eegeo.mapapi.services.mapscene.MapsceneRequest;
import com.eegeo.mapapi.services.mapscene.MapsceneRequestOptions;
import com.eegeo.mapapi.services.poi.MapsceneRequestResponse;
import java.util.concurrent.Callable;

public class MapsceneApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<MapsceneRequest> m_nativeHandleToMapsceneRequest = new SparseArray();
    private MapsceneApplier m_mapsceneApplier;

    public MapsceneApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
        this.m_mapsceneApplier = null;
    }

    @UiThread
    public MapsceneRequest requestMapscene(final MapsceneRequestOptions options) {
        MapsceneRequest request = new MapsceneRequest(this, options.getApplyOnLoad(), options.getOnMapsceneRequestCompletedListener(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return MapsceneApi.this.beginMapsceneRequest(options);
            }
        });
        return request;
    }

    @WorkerThread
    void register(MapsceneRequest mapsceneRequest, int nativeHandle) {
        this.m_nativeHandleToMapsceneRequest.put(nativeHandle, (Object)mapsceneRequest);
    }

    @WorkerThread
    void unregister(int nativeHandle) {
        this.m_nativeHandleToMapsceneRequest.remove(nativeHandle);
    }

    @WorkerThread
    public void notifyRequestComplete(int nativeHandle, boolean succeeded, Mapscene mapscene) {
        MapsceneRequestResponse result = new MapsceneRequestResponse(succeeded, mapscene);
        if (this.m_nativeHandleToMapsceneRequest.get(nativeHandle) != null) {
            this.returnMapsceneResponse(nativeHandle, result);
        }
    }

    @WorkerThread
    void returnMapsceneResponse(int nativeHandle, final MapsceneRequestResponse response) {
        final MapsceneRequest mapsceneRequest = (MapsceneRequest)this.m_nativeHandleToMapsceneRequest.get(nativeHandle);
        if (mapsceneRequest == null) {
            throw new NullPointerException("MapsceneRequest object not found for nativeHandle");
        }
        this.m_uiRunner.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (response.succeeded() && mapsceneRequest.shouldApplyOnLoad() && MapsceneApi.this.m_mapsceneApplier != null) {
                    MapsceneApi.this.m_mapsceneApplier.ApplyMapscene(response.getMapscene());
                }
                mapsceneRequest.returnResponse(response);
            }
        });
        this.m_nativeHandleToMapsceneRequest.remove(nativeHandle);
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    int beginMapsceneRequest(MapsceneRequestOptions options) {
        return this.nativeBeginMapsceneRequest(this.m_jniEegeoMapApiPtr, options.getUrlOrShortlink(), options.getApplyOnLoad());
    }

    @WorkerThread
    void cancelRequest(int searchNativeHandle) {
        this.nativeCancelRequest(this.m_jniEegeoMapApiPtr, searchNativeHandle);
        this.m_nativeHandleToMapsceneRequest.remove(searchNativeHandle);
    }

    private native int nativeBeginMapsceneRequest(long var1, String var3, boolean var4);

    private native void nativeCancelRequest(long var1, int var3);

    public void setMapsceneApplier(MapsceneApplier mapsceneApplier) {
        this.m_mapsceneApplier = mapsceneApplier;
    }
}

