/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.positioner;

import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.positioner.OnPositionerChangedListener;

public final class PositionerOptions {
    private LatLng m_position;
    private double m_elevation;
    private ElevationMode m_elevationMode = ElevationMode.HeightAboveGround;
    private String m_indoorMapId = "";
    private int m_indoorFloorId;
    private OnPositionerChangedListener m_onPositionerChangedListener = null;

    public PositionerOptions position(LatLng position) {
        this.m_position = position;
        return this;
    }

    public PositionerOptions elevation(double elevation) {
        this.m_elevation = elevation;
        return this;
    }

    public PositionerOptions elevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        return this;
    }

    public PositionerOptions indoor(String indoorMapId, int indoorFloorId) {
        this.m_indoorMapId = indoorMapId;
        this.m_indoorFloorId = indoorFloorId;
        return this;
    }

    public PositionerOptions positionerChangedListener(OnPositionerChangedListener listener) {
        this.m_onPositionerChangedListener = listener;
        return this;
    }

    LatLng getPosition() {
        return this.m_position;
    }

    double getElevation() {
        return this.m_elevation;
    }

    ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    OnPositionerChangedListener getPositionerChangedListener() {
        return this.m_onPositionerChangedListener;
    }
}

