/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.positioner;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.positioner.OnPositionerChangedListener;
import com.eegeo.mapapi.positioner.PositionerApi;
import com.eegeo.mapapi.positioner.PositionerOptions;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class Positioner
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final PositionerApi m_positionerApi;
    private String m_indoorMapId;
    private int m_indoorFloorId;
    private LatLng m_position;
    private double m_elevation;
    private ElevationMode m_elevationMode;
    private OnPositionerChangedListener m_positionerChangedListener;
    private Point m_screenPoint = new Point();
    private boolean m_isScreenPointValid = false;
    private boolean m_isBehindGlobeHorizon = false;

    @UiThread
    public Positioner(final @NonNull PositionerApi positionerApi, final @NonNull PositionerOptions positionerOptions) {
        super(positionerApi.getNativeRunner(), positionerApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return positionerApi.createPositioner(positionerOptions, m_allowHandleAccess);
            }
        });
        this.m_positionerApi = positionerApi;
        this.m_position = positionerOptions.getPosition();
        this.m_elevation = positionerOptions.getElevation();
        this.m_elevationMode = positionerOptions.getElevationMode();
        this.m_indoorMapId = positionerOptions.getIndoorMapId();
        this.m_indoorFloorId = positionerOptions.getIndoorFloorId();
        this.m_positionerChangedListener = positionerOptions.getPositionerChangedListener();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                positionerApi.registerPositioner(Positioner.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public LatLng getPosition() {
        return this.m_position;
    }

    @UiThread
    public void setPosition(@NonNull LatLng position) {
        this.m_position = position;
        this.updateLocation();
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateLocation();
    }

    @UiThread
    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    @UiThread
    public void setElevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        this.updateLocation();
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public void setIndoorMapId(String indoorMapId) {
        this.m_indoorMapId = indoorMapId;
        this.updateLocation();
    }

    @UiThread
    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    @UiThread
    public void setIndoorFloorId(int indoorFloorId) {
        this.m_indoorFloorId = indoorFloorId;
        this.updateLocation();
    }

    @UiThread
    public Point tryGetScreenPoint() {
        return this.m_isScreenPointValid ? this.m_screenPoint : null;
    }

    @UiThread
    public boolean isBehindGlobeHorizon() {
        return this.m_isBehindGlobeHorizon;
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Positioner.this.m_positionerApi.destroy(Positioner.this, m_allowHandleAccess);
                Positioner.this.m_positionerApi.unregisterPositioner(Positioner.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    private void updateLocation() {
        final LatLng position = this.m_position;
        final double elevation = this.m_elevation;
        final ElevationMode elevationMode = this.m_elevationMode;
        final String indoorMapId = this.m_indoorMapId;
        final int indoorFloorId = this.m_indoorFloorId;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Positioner.this.m_positionerApi.updateLocation(Positioner.this.getNativeHandle(), m_allowHandleAccess, position, elevation, elevationMode, indoorMapId, indoorFloorId);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by PositionerApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    @UiThread
    void setProjectedState(Point screenPoint, boolean isScreenPointValid, boolean isBehindGlobeHorizon) {
        if (!this.m_screenPoint.equals((Object)screenPoint) || this.m_isScreenPointValid != isScreenPointValid || this.m_isBehindGlobeHorizon != isBehindGlobeHorizon) {
            if (screenPoint != null) {
                this.m_screenPoint.set(screenPoint.x, screenPoint.y);
            }
            this.m_isScreenPointValid = isScreenPointValid;
            this.m_isBehindGlobeHorizon = isBehindGlobeHorizon;
            if (this.m_positionerChangedListener != null) {
                this.m_positionerChangedListener.onPositionerChanged(this);
            }
        }
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

