/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.buildings;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.buildings.BuildingHighlightOptions;
import com.eegeo.mapapi.buildings.BuildingInformation;
import com.eegeo.mapapi.buildings.BuildingsApi;
import com.eegeo.mapapi.buildings.OnBuildingInformationReceivedListener;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class BuildingHighlight
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final BuildingsApi m_buildingsApi;
    private int m_colorARGB;
    private boolean m_shouldCreateView;
    private BuildingInformation m_buildingInformation = null;
    private OnBuildingInformationReceivedListener m_onBuildingInformationReceivedListener;

    @UiThread
    public BuildingHighlight(final @NonNull BuildingsApi buildingsApi, final @NonNull BuildingHighlightOptions buildingHighlightOptions) {
        super(buildingsApi.getNativeRunner(), buildingsApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return buildingsApi.create(buildingHighlightOptions, m_allowHandleAccess);
            }
        });
        this.m_buildingsApi = buildingsApi;
        this.m_colorARGB = buildingHighlightOptions.getColor();
        this.m_shouldCreateView = buildingHighlightOptions.getShouldCreateView();
        this.m_onBuildingInformationReceivedListener = buildingHighlightOptions.getOnBuildingInformationReceivedListener();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BuildingHighlight.this.m_buildingsApi.register(BuildingHighlight.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public int getColor() {
        return this.m_colorARGB;
    }

    @UiThread
    public void setColor(int color) {
        this.m_colorARGB = color;
        this.updateNativeStyleAttributes();
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BuildingHighlight.this.m_buildingsApi.destroy(BuildingHighlight.this, m_allowHandleAccess);
                BuildingHighlight.this.m_buildingsApi.unregister(BuildingHighlight.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    void setBuildingInformation(BuildingInformation buildingInformation) {
        this.m_buildingInformation = buildingInformation;
        if (this.m_onBuildingInformationReceivedListener != null) {
            this.m_onBuildingInformationReceivedListener.onBuildingInformationReceived(this);
        }
    }

    @UiThread
    public BuildingInformation getBuildingInformation() {
        return this.m_buildingInformation;
    }

    @UiThread
    private void updateNativeStyleAttributes() {
        final int colorARGB = this.m_colorARGB;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BuildingHighlight.this.m_buildingsApi.setStyleAttributes(BuildingHighlight.this.getNativeHandle(), m_allowHandleAccess, colorARGB);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by BuildingsApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

