/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.polylines;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.polylines.PolylineApi;
import com.eegeo.mapapi.polylines.PolylineOptions;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.List;
import java.util.concurrent.Callable;

public class Polyline
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final PolylineApi m_polylineApi;
    private String m_indoorMapId;
    private int m_indoorFloorId;
    private double m_elevation;
    private ElevationMode m_elevationMode;
    private List<LatLng> m_points;
    private float m_width;
    private int m_colorARGB;

    @UiThread
    public Polyline(final @NonNull PolylineApi polylineApi, final @NonNull PolylineOptions polylineOptions) {
        super(polylineApi.getNativeRunner(), polylineApi.getUiRunner(), new Callable<Integer>(){

            @Override
            @WorkerThread
            public Integer call() throws Exception {
                return polylineApi.create(polylineOptions, m_allowHandleAccess);
            }
        });
        this.m_polylineApi = polylineApi;
        this.m_indoorMapId = polylineOptions.getIndoorMapId();
        this.m_indoorFloorId = polylineOptions.getIndoorFloorId();
        this.m_elevation = polylineOptions.getElevation();
        this.m_elevationMode = polylineOptions.getElevationMode();
        this.m_points = polylineOptions.getPoints();
        this.m_width = polylineOptions.getWidth();
        this.m_colorARGB = polylineOptions.getColor();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                polylineApi.register(Polyline.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateNativeElevation();
    }

    @UiThread
    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    @UiThread
    public void setElevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        this.updateNativeElevation();
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public void setIndoorMapId(String indoorMapId) {
        this.m_indoorMapId = indoorMapId;
        this.updateNativeIndoorMap();
    }

    @UiThread
    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    @UiThread
    public void setIndoorFloorId(int indoorFloorId) {
        this.m_indoorFloorId = indoorFloorId;
        this.updateNativeIndoorMap();
    }

    @UiThread
    public float getWidth() {
        return this.m_width;
    }

    @UiThread
    public void setWidth(float width) {
        this.m_width = width;
        this.updateNativeStyleAttributes();
    }

    @UiThread
    public int getColor() {
        return this.m_colorARGB;
    }

    @UiThread
    public void setColor(int color) {
        this.m_colorARGB = color;
        this.updateNativeStyleAttributes();
    }

    @UiThread
    public List<LatLng> getPoints() {
        return this.m_points;
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polyline.this.m_polylineApi.destroy(Polyline.this, m_allowHandleAccess);
                Polyline.this.m_polylineApi.unregister(Polyline.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    private void updateNativeIndoorMap() {
        final String indoorMapId = this.m_indoorMapId;
        final int indoorFloorId = this.m_indoorFloorId;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polyline.this.m_polylineApi.setIndoorMap(Polyline.this.getNativeHandle(), m_allowHandleAccess, indoorMapId, indoorFloorId);
            }
        });
    }

    @UiThread
    private void updateNativeElevation() {
        final double elevation = this.m_elevation;
        final ElevationMode elevationMode = this.m_elevationMode;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polyline.this.m_polylineApi.setElevation(Polyline.this.getNativeHandle(), m_allowHandleAccess, elevation, elevationMode);
            }
        });
    }

    @UiThread
    private void updateNativeStyleAttributes() {
        final float width = this.m_width;
        final int colorARGB = this.m_colorARGB;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Polyline.this.m_polylineApi.setStyleAttributes(Polyline.this.getNativeHandle(), m_allowHandleAccess, width, colorARGB);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by PolylineApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

