/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.bluesphere;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.bluesphere.BlueSphere;
import com.eegeo.mapapi.geometry.LatLng;

public class BlueSphereApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;

    public BlueSphereApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    public INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    public IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void setCoordinate(BlueSphere.AllowHandleAccess allowHandleAccess, LatLng position) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BlueSphere");
        }
        this.nativeSetCoordinate(this.m_jniEegeoMapApiPtr, position.latitude, position.longitude);
    }

    @WorkerThread
    public void setElevation(BlueSphere.AllowHandleAccess allowHandleAccess, double elevation) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BlueSphere");
        }
        this.nativeSetElevation(this.m_jniEegeoMapApiPtr, elevation);
    }

    @WorkerThread
    public void setIndoorMap(BlueSphere.AllowHandleAccess allowHandleAccess, String indoorMap, int floorId) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BlueSphere");
        }
        this.nativeSetIndoorMap(this.m_jniEegeoMapApiPtr, indoorMap, floorId);
    }

    @WorkerThread
    public void setEnabled(BlueSphere.AllowHandleAccess allowHandleAccess, boolean enabled) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BlueSphere");
        }
        this.nativeSetEnabled(this.m_jniEegeoMapApiPtr, enabled);
    }

    @WorkerThread
    public void setDirection(BlueSphere.AllowHandleAccess allowHandleAccess, double headingDegreesFromNorth) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by BlueSphere");
        }
        this.nativeSetDirection(this.m_jniEegeoMapApiPtr, headingDegreesFromNorth);
    }

    @WorkerThread
    private native void nativeSetCoordinate(long var1, double var3, double var5);

    @WorkerThread
    private native void nativeSetElevation(long var1, double var3);

    @WorkerThread
    private native void nativeSetIndoorMap(long var1, String var3, int var4);

    @WorkerThread
    private native void nativeSetEnabled(long var1, boolean var3);

    @WorkerThread
    private native void nativeSetDirection(long var1, double var3);
}

