/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.map;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.eegeo.mapapi.R;
import com.eegeo.mapapi.camera.CameraPosition;

public class EegeoMapOptions {
    private CameraPosition m_camera;
    private float m_targetFrameRate = 30.0f;
    private String m_coverageTreeManifest = "";
    private String m_environmentThemesManifest = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EegeoMapOptions createFromAttributeSet(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        EegeoMapOptions eegeoMapOptions = new EegeoMapOptions();
        TypedArray styledAttributes = context.obtainStyledAttributes(attributeSet, R.styleable.eegeo_MapView, 0, 0);
        try {
            eegeoMapOptions.camera(new CameraPosition.Builder(styledAttributes).build());
        }
        finally {
            styledAttributes.recycle();
        }
        return eegeoMapOptions;
    }

    public EegeoMapOptions camera(CameraPosition camera) {
        this.m_camera = camera;
        return this;
    }

    public EegeoMapOptions coverageTreeManifest(String coverageTreeManifest) {
        this.m_coverageTreeManifest = coverageTreeManifest;
        return this;
    }

    public EegeoMapOptions environmentThemesManifest(String environmentThemesManifest) {
        this.m_environmentThemesManifest = environmentThemesManifest;
        return this;
    }

    public CameraPosition getCamera() {
        return this.m_camera;
    }

    public float getTargetFrameRate() {
        return this.m_targetFrameRate;
    }

    public String getCoverageTreeManifest() {
        return this.m_coverageTreeManifest;
    }

    public String getEnvironmentThemesManifest() {
        return this.m_environmentThemesManifest;
    }
}

