/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.camera;

import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import com.eegeo.mapapi.R;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.LatLngAlt;

public final class CameraPosition {
    public final LatLngAlt target;
    public final double zoom;
    public final double tilt;
    public final double bearing;
    public final double distance;
    public final boolean modifyTarget;
    public final boolean modifyDistance;
    public final boolean modifyBearing;
    public final boolean modifyTilt;

    public CameraPosition(LatLngAlt target, double zoom, double tilt, double bearing) {
        this.target = target;
        this.zoom = zoom;
        this.tilt = tilt;
        this.bearing = bearing;
        this.distance = Builder.ZoomToDistance(zoom);
        this.modifyTarget = true;
        this.modifyDistance = true;
        this.modifyBearing = true;
        this.modifyTilt = true;
    }

    private CameraPosition(LatLngAlt target, boolean modifyTarget, double distance, boolean modifyDistance, double bearing, boolean modifyBearing, double tilt, boolean modifyTilt) {
        this.target = target;
        this.tilt = tilt;
        this.bearing = bearing;
        this.zoom = Builder.DistanceToZoom(distance);
        this.distance = distance;
        this.modifyTarget = modifyTarget;
        this.modifyDistance = modifyDistance;
        this.modifyBearing = modifyBearing;
        this.modifyTilt = modifyTilt;
    }

    public static final class Builder {
        private static double[] ms_zoomToDistances = new double[]{2.74287E7, 1.4720762E7, 8000000.0, 4512909.0, 2087317.0, 1248854.0, 660556.0, 351205.0, 185652.0, 83092.0, 41899.0, 21377.0, 11294.0, 5818.0, 3106.0, 1890.0, 1300.0, 821.0, 500.0, 300.0, 108.0, 58.0, 31.0, 17.0, 9.0, 5.0};
        private LatLngAlt m_target;
        private double m_distance = 0.0;
        private double m_tilt = 0.0;
        private double m_bearing = 0.0;
        private boolean m_modifyTarget = false;
        private boolean m_modifyTilt = false;
        private boolean m_modifyBearing = false;
        private boolean m_modifyDistance = false;

        public Builder() {
        }

        public Builder(@NonNull TypedArray typedArray) {
            double lat = typedArray.getFloat(R.styleable.eegeo_MapView_camera_target_latitude, 0.0f);
            double lng = typedArray.getFloat(R.styleable.eegeo_MapView_camera_target_longitude, 0.0f);
            double altitude = typedArray.getFloat(R.styleable.eegeo_MapView_camera_target_altitude, 0.0f);
            this.target(lat, lng, altitude);
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_distance)) {
                double distance = typedArray.getFloat(R.styleable.eegeo_MapView_camera_distance, 0.0f);
                this.distance(distance);
            } else if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_zoom)) {
                double zoom = typedArray.getFloat(R.styleable.eegeo_MapView_camera_zoom, 0.0f);
                this.zoom(zoom);
            }
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_bearing)) {
                double bearing = typedArray.getFloat(R.styleable.eegeo_MapView_camera_bearing, 0.0f);
                this.bearing(bearing);
            }
            if (typedArray.hasValue(R.styleable.eegeo_MapView_camera_tilt)) {
                double tilt = typedArray.getFloat(R.styleable.eegeo_MapView_camera_tilt, 0.0f);
                this.tilt(tilt);
            }
        }

        public static double ZoomToDistance(double zoom) {
            int zoomLevel = (int)zoom;
            if (zoomLevel < 0) {
                return ms_zoomToDistances[0];
            }
            if (zoomLevel >= ms_zoomToDistances.length) {
                return ms_zoomToDistances[ms_zoomToDistances.length - 1];
            }
            return ms_zoomToDistances[zoomLevel];
        }

        public static double DistanceToZoom(double distance) {
            for (int i = 0; i < ms_zoomToDistances.length; ++i) {
                if (!(distance >= ms_zoomToDistances[i])) continue;
                return i;
            }
            return 17.0;
        }

        public Builder bearing(double bearing) {
            while (bearing >= 360.0) {
                bearing -= 360.0;
            }
            while (bearing < 0.0) {
                bearing += 360.0;
            }
            this.m_bearing = bearing;
            this.m_modifyBearing = true;
            return this;
        }

        public Builder target(double latitude, double longitude) {
            this.m_target = new LatLngAlt(latitude, longitude, 0.0);
            this.m_modifyTarget = true;
            return this;
        }

        public Builder target(double latitude, double longitude, double altitude) {
            this.m_target = new LatLngAlt(latitude, longitude, altitude);
            this.m_modifyTarget = true;
            return this;
        }

        public Builder target(@NonNull LatLng latLon) {
            this.m_target = new LatLngAlt(latLon.latitude, latLon.longitude, 0.0);
            this.m_modifyTarget = true;
            return this;
        }

        public Builder target(@NonNull LatLngAlt latLonAlt) {
            this.m_target = latLonAlt;
            this.m_modifyTarget = true;
            return this;
        }

        private Builder distance(double distance) {
            this.m_distance = distance;
            this.m_modifyDistance = true;
            return this;
        }

        public Builder zoom(double zoom) {
            this.distance(Builder.ZoomToDistance(zoom));
            return this;
        }

        public Builder tilt(double tilt) {
            this.m_tilt = Math.min(Math.max(tilt, 0.0), 90.0);
            this.m_modifyTilt = true;
            return this;
        }

        public final CameraPosition build() {
            return new CameraPosition(this.m_target, this.m_modifyTarget, this.m_distance, this.m_modifyDistance, this.m_bearing, this.m_modifyBearing, this.m_tilt, this.m_modifyTilt);
        }
    }
}

