/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.bluesphere;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.bluesphere.BlueSphereApi;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class BlueSphere
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final BlueSphereApi m_bluesphereApi;
    private String m_indoorMapId;
    private int m_indoorFloorId;
    private LatLng m_position;
    private double m_bearing;
    private double m_elevation;
    private boolean m_enabled;
    private boolean m_accuracyRingEnabled;
    private float m_accuracyInMeters;
    private boolean m_orientationVisible;

    @UiThread
    public BlueSphere(@NonNull BlueSphereApi bluesphereApi) {
        super(bluesphereApi.getNativeRunner(), bluesphereApi.getUiRunner(), new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 0;
            }
        });
        this.m_bluesphereApi = bluesphereApi;
        this.m_position = new LatLng(0.0, 0.0);
        this.m_elevation = 0.0;
        this.m_indoorMapId = null;
        this.m_indoorFloorId = 0;
        this.m_enabled = false;
        this.m_accuracyRingEnabled = false;
        this.m_accuracyInMeters = 0.0f;
        this.m_orientationVisible = true;
    }

    @UiThread
    public LatLng getPosition() {
        return this.m_position;
    }

    @UiThread
    public void setPosition(@NonNull LatLng position) {
        this.m_position = position;
        this.updateCoordinate();
    }

    @UiThread
    public double getBearing() {
        return this.m_bearing;
    }

    @UiThread
    public void setBearing(@NonNull double bearing) {
        this.m_bearing = bearing;
        this.updateBearing();
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateElevation();
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public void setIndoorMap(String indoorMapId, int floorId) {
        this.m_indoorMapId = indoorMapId;
        this.m_indoorFloorId = floorId;
        this.updateIndoors();
    }

    @UiThread
    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    @UiThread
    public void setIndoorFloorId(int floorId) {
        this.m_indoorFloorId = floorId;
    }

    @UiThread
    public boolean getEnabled() {
        return this.m_enabled;
    }

    @UiThread
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.updateEnabled();
    }

    @UiThread
    private void updateEnabled() {
        final boolean enabled = this.m_enabled;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.setEnabled(m_allowHandleAccess, enabled);
            }
        });
    }

    @UiThread
    public boolean getAccuracyRingEnabled() {
        return this.m_accuracyRingEnabled;
    }

    @UiThread
    public void setAccuracyRingEnabled(boolean accuracyRingEnabled) {
        this.m_accuracyRingEnabled = accuracyRingEnabled;
        this.updateAccuracyRingEnabled();
    }

    @UiThread
    private void updateAccuracyRingEnabled() {
        final boolean accuracyRingEnabled = this.m_accuracyRingEnabled;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.setAccuracyRingEnabled(m_allowHandleAccess, accuracyRingEnabled);
            }
        });
    }

    @UiThread
    public float getCurrentLocationAccuracy() {
        return this.m_accuracyInMeters;
    }

    @UiThread
    public void setCurrentLocationAccuracy(float accuracyInMeters) {
        this.m_accuracyInMeters = accuracyInMeters;
        this.updateCurrentLocationAccuracy();
    }

    @UiThread
    private void updateCurrentLocationAccuracy() {
        final float accuracyInMeters = this.m_accuracyInMeters;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.setCurrentLocationAccuracy(m_allowHandleAccess, accuracyInMeters);
            }
        });
    }

    @UiThread
    public void showOrientation(boolean orientationVisible) {
        this.m_orientationVisible = orientationVisible;
        this.updateOrientation();
    }

    @UiThread
    private void updateOrientation() {
        final boolean showOrientation = this.m_orientationVisible;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.showOrientation(m_allowHandleAccess, showOrientation);
            }
        });
    }

    @UiThread
    private void updateBearing() {
        final double bearing = this.m_bearing;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.setBearing(m_allowHandleAccess, bearing);
            }
        });
    }

    @UiThread
    private void updateCoordinate() {
        final LatLng position = this.m_position;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.setCoordinate(m_allowHandleAccess, position);
            }
        });
    }

    @UiThread
    private void updateElevation() {
        final double elevation = this.m_elevation;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.setElevation(m_allowHandleAccess, elevation);
            }
        });
    }

    @UiThread
    private void updateIndoors() {
        final String indoorMap = this.m_indoorMapId;
        final int floorId = this.m_indoorFloorId;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                BlueSphere.this.m_bluesphereApi.setIndoorMap(m_allowHandleAccess, indoorMap, floorId);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by BlueSphereApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

