/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.widgets;

import android.support.annotation.UiThread;
import com.eegeo.mapapi.EegeoMap;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.polylines.Polyline;
import com.eegeo.mapapi.polylines.PolylineOptions;
import com.eegeo.mapapi.services.routing.Route;
import com.eegeo.mapapi.services.routing.RouteSection;
import com.eegeo.mapapi.services.routing.RouteStep;
import com.eegeo.mapapi.widgets.RouteViewAmalgamationHelper;
import com.eegeo.mapapi.widgets.RouteViewHelper;
import com.eegeo.mapapi.widgets.RouteViewOptions;
import com.eegeo.mapapi.widgets.RoutingPolylineCreateParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteView {
    private EegeoMap m_map = null;
    private Route m_route = null;
    private List<Polyline> m_polylinesForward = new ArrayList<Polyline>();
    private List<Polyline> m_polylinesBackward = new ArrayList<Polyline>();
    private boolean m_currentlyOnMap = false;
    private float m_width;
    private int m_colorARGB;
    private int m_forwardPathColorARGB;
    private float m_miterLimit;
    private Map<Integer, List<RoutingPolylineCreateParams>> m_routeStepToPolylineCreateParams = new HashMap<Integer, List<RoutingPolylineCreateParams>>();

    public RouteView(EegeoMap map, Route route, RouteViewOptions options) {
        this.m_map = map;
        this.m_route = route;
        this.m_width = options.getWidth();
        this.m_colorARGB = options.getColor();
        this.m_forwardPathColorARGB = options.getForwardPathColor();
        this.m_miterLimit = options.getMiterLimit();
        this.addToMap();
    }

    public void addToMap() {
        int flattenedStepIndex = 0;
        for (RouteSection section : this.m_route.sections) {
            List<RouteStep> steps = section.steps;
            for (int i = 0; i < steps.size(); ++i) {
                RouteStep step = steps.get(i);
                if (step.path.size() < 2) continue;
                if (step.isMultiFloor) {
                    boolean isValidTransition;
                    boolean bl = isValidTransition = i > 0 && i < steps.size() - 1 && step.isIndoors;
                    if (!isValidTransition) continue;
                    RouteStep stepBefore = steps.get(i - 1);
                    RouteStep stepAfter = steps.get(i + 1);
                    this.addLineCreationParamsForStep(step, stepBefore.indoorFloorId, stepAfter.indoorFloorId, flattenedStepIndex, false);
                } else {
                    this.addLineCreationParamsForStep(step, flattenedStepIndex);
                }
                ++flattenedStepIndex;
            }
        }
        this.refreshPolylines();
        this.m_currentlyOnMap = true;
    }

    private void addLineCreationParamsForStep(RouteStep routeStep, int flattenedStepIndex) {
        if (routeStep.path.size() < 2) {
            return;
        }
        this.m_routeStepToPolylineCreateParams.put(flattenedStepIndex, RouteViewHelper.createLinesForRouteDirection(routeStep, false));
    }

    private void addLineCreationParamsForStep(RouteStep routeStep, int stepBefore, int stepAfter, int flattenedStepIndex, boolean isForwardColor) {
        if (routeStep.path.size() < 2) {
            return;
        }
        this.m_routeStepToPolylineCreateParams.put(flattenedStepIndex, RouteViewHelper.createLinesForFloorTransition(routeStep, stepBefore, stepAfter, isForwardColor));
    }

    private void addLineCreationParamsForStep(RouteStep routeStep, int stepIndex, LatLng closestPointOnPath, int splitIndex) {
        if (routeStep.path.size() < 2) {
            return;
        }
        this.m_routeStepToPolylineCreateParams.put(stepIndex, RouteViewHelper.createLinesForRouteDirection(routeStep, splitIndex, closestPointOnPath));
    }

    private void refreshPolylines() {
        Polyline routeLine;
        this.removeFromMap();
        ArrayList<RoutingPolylineCreateParams> allPolylineCreateParams = new ArrayList<RoutingPolylineCreateParams>();
        for (int i = 0; i < this.m_routeStepToPolylineCreateParams.size(); ++i) {
            allPolylineCreateParams.addAll((Collection)this.m_routeStepToPolylineCreateParams.get(i));
        }
        ArrayList<PolylineOptions> backwardPolyLineOptionsList = new ArrayList<PolylineOptions>();
        ArrayList<PolylineOptions> forwardPolyLineOptionsList = new ArrayList<PolylineOptions>();
        RouteViewAmalgamationHelper.createPolylines(allPolylineCreateParams, this.m_width, this.m_miterLimit, backwardPolyLineOptionsList, forwardPolyLineOptionsList);
        for (PolylineOptions polyLineOption : backwardPolyLineOptionsList) {
            polyLineOption.color(this.m_colorARGB);
            routeLine = this.m_map.addPolyline(polyLineOption);
            this.m_polylinesBackward.add(routeLine);
        }
        for (PolylineOptions polyLineOption : forwardPolyLineOptionsList) {
            polyLineOption.color(this.m_forwardPathColorARGB);
            routeLine = this.m_map.addPolyline(polyLineOption);
            this.m_polylinesForward.add(routeLine);
        }
    }

    public void updateRouteProgress(int sectionIndex, int stepIndex, LatLng closestPointOnRoute, int indexOfPathSegmentStartVertex) {
        this.removeFromMap();
        int flattenedStepIndex = 0;
        for (int x = 0; x < this.m_route.sections.size(); ++x) {
            List<RouteStep> steps = this.m_route.sections.get((int)x).steps;
            for (int i = 0; i < steps.size(); ++i) {
                boolean isActiveStep;
                RouteStep step = steps.get(i);
                boolean bl = isActiveStep = sectionIndex == x && stepIndex == i;
                if (step.path.size() < 2) continue;
                if (step.isMultiFloor) {
                    boolean isValidTransition;
                    boolean bl2 = isValidTransition = i > 0 && i < steps.size() - 1 && step.isIndoors;
                    if (!isValidTransition) continue;
                    RouteStep stepBefore = steps.get(i - 1);
                    RouteStep stepAfter = steps.get(i + 1);
                    if (isActiveStep) {
                        boolean hasReachedEnd = indexOfPathSegmentStartVertex == step.path.size() - 1;
                        this.addLineCreationParamsForStep(step, stepBefore.indoorFloorId, stepAfter.indoorFloorId, flattenedStepIndex, !hasReachedEnd);
                    } else {
                        this.addLineCreationParamsForStep(step, stepBefore.indoorFloorId, stepAfter.indoorFloorId, flattenedStepIndex, false);
                    }
                } else if (isActiveStep) {
                    this.addLineCreationParamsForStep(step, flattenedStepIndex, closestPointOnRoute, indexOfPathSegmentStartVertex);
                } else {
                    this.addLineCreationParamsForStep(step, flattenedStepIndex);
                }
                ++flattenedStepIndex;
            }
        }
        this.refreshPolylines();
    }

    public void removeFromMap() {
        for (Polyline polyline : this.m_polylinesBackward) {
            this.m_map.removePolyline(polyline);
        }
        this.m_polylinesBackward.clear();
        for (Polyline polyline : this.m_polylinesForward) {
            this.m_map.removePolyline(polyline);
        }
        this.m_polylinesForward.clear();
        this.m_currentlyOnMap = false;
    }

    @UiThread
    public void setWidth(float width) {
        this.m_width = width;
        for (Polyline polyline : this.m_polylinesBackward) {
            polyline.setWidth(this.m_width);
        }
        for (Polyline polyline : this.m_polylinesForward) {
            polyline.setWidth(this.m_width);
        }
    }

    @UiThread
    public void setColor(int color) {
        this.m_colorARGB = color;
        for (Polyline polyline : this.m_polylinesBackward) {
            polyline.setColor(this.m_colorARGB);
        }
    }

    @UiThread
    public void setForwardColor(int color) {
        this.m_forwardPathColorARGB = color;
        for (Polyline polyline : this.m_polylinesForward) {
            polyline.setColor(this.m_forwardPathColorARGB);
        }
    }

    @UiThread
    public void setMiterLimit(float miterLimit) {
        this.m_miterLimit = miterLimit;
        for (Polyline polyline : this.m_polylinesBackward) {
            polyline.setMiterLimit(this.m_miterLimit);
        }
        for (Polyline polyline : this.m_polylinesForward) {
            polyline.setMiterLimit(this.m_miterLimit);
        }
    }
}

