/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.widgets;

import android.util.Pair;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.polylines.PolylineOptions;
import com.eegeo.mapapi.widgets.RouteViewHelper;
import com.eegeo.mapapi.widgets.RoutingPolylineCreateParams;
import java.util.ArrayList;
import java.util.List;

class RouteViewAmalgamationHelper {
    RouteViewAmalgamationHelper() {
    }

    public static void createPolylines(List<RoutingPolylineCreateParams> params, float width, float miterLimit, List<PolylineOptions> out_backwardPolylinesOptions, List<PolylineOptions> out_forwardPolylinesOptions) {
        List<Pair<Integer, Integer>> ranges = RouteViewAmalgamationHelper.buildAmalgamationRanges(params);
        for (Pair<Integer, Integer> range : ranges) {
            PolylineOptions polylineOption = new PolylineOptions().width(width).miterLimit(miterLimit);
            boolean isLineCreated = RouteViewAmalgamationHelper.createAmalgamatedPolylineForRange(params, (Integer)range.first, (Integer)range.second, polylineOption);
            if (!isLineCreated) continue;
            if (params.get((int)((Integer)range.first).intValue()).isForwardColor) {
                out_forwardPolylinesOptions.add(polylineOption);
                continue;
            }
            out_backwardPolylinesOptions.add(polylineOption);
        }
    }

    public static List<Pair<Integer, Integer>> buildAmalgamationRanges(List<RoutingPolylineCreateParams> polylineCreateParams) {
        ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
        if (polylineCreateParams.isEmpty()) {
            return ranges;
        }
        int rangeStart = 0;
        for (int i = 1; i < polylineCreateParams.size(); ++i) {
            RoutingPolylineCreateParams b;
            RoutingPolylineCreateParams a = polylineCreateParams.get(i - 1);
            if (RouteViewAmalgamationHelper.canAmalgamate(a, b = polylineCreateParams.get(i))) continue;
            ranges.add((Pair<Integer, Integer>)new Pair((Object)rangeStart, (Object)i));
            rangeStart = i;
        }
        ranges.add((Pair<Integer, Integer>)new Pair((Object)rangeStart, (Object)polylineCreateParams.size()));
        return ranges;
    }

    public static boolean canAmalgamate(RoutingPolylineCreateParams a, RoutingPolylineCreateParams b) {
        if (a.isIndoor != b.isIndoor) {
            return false;
        }
        if (!a.indoorMapId.equals(b.indoorMapId)) {
            return false;
        }
        if (a.indoorFloorId != b.indoorFloorId) {
            return false;
        }
        return a.isForwardColor == b.isForwardColor;
    }

    public static boolean createAmalgamatedPolylineForRange(List<RoutingPolylineCreateParams> polylineCreateParams, Integer rangeStartIndex, Integer rangeEndIndex, PolylineOptions out_polylineOption) {
        RoutingPolylineCreateParams params;
        int i;
        ArrayList<LatLng> joinedCoordinates = new ArrayList<LatLng>();
        ArrayList<Double> joinedPerPointElevations = new ArrayList<Double>();
        boolean anyPerPointElevations = false;
        for (i = rangeStartIndex.intValue(); i < rangeEndIndex; ++i) {
            params = polylineCreateParams.get(i);
            List<LatLng> coordinates = params.path;
            joinedCoordinates.addAll(coordinates);
            if (params.perPointElevations == null) continue;
            anyPerPointElevations = true;
        }
        if (anyPerPointElevations) {
            for (i = rangeStartIndex.intValue(); i < rangeEndIndex; ++i) {
                params = polylineCreateParams.get(i);
                List<Double> perPointElevations = params.perPointElevations;
                if (perPointElevations == null) {
                    for (int x = 0; x < params.path.size(); ++x) {
                        joinedPerPointElevations.add(0.0);
                    }
                    continue;
                }
                joinedPerPointElevations.addAll(params.perPointElevations);
            }
            RouteViewHelper.removeCoincidentPointsWithElevations(joinedCoordinates, joinedPerPointElevations);
        } else {
            RouteViewHelper.removeCoincidentPoints(joinedCoordinates);
        }
        if (joinedCoordinates.size() > 1) {
            RoutingPolylineCreateParams param = polylineCreateParams.get(rangeStartIndex);
            if (param.isIndoor) {
                out_polylineOption.indoor(param.indoorMapId, param.indoorFloorId);
            }
            for (int i2 = 0; i2 < joinedCoordinates.size(); ++i2) {
                LatLng point = (LatLng)joinedCoordinates.get(i2);
                if (anyPerPointElevations) {
                    Double elevation = (Double)joinedPerPointElevations.get(i2);
                    out_polylineOption.add(point, elevation);
                    continue;
                }
                out_polylineOption.add(point);
            }
            return true;
        }
        return false;
    }
}

