/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.widgets;

import android.location.Location;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.services.routing.RouteStep;
import com.eegeo.mapapi.widgets.RoutingPolylineCreateParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class RouteViewHelper {
    private static final double VERTICAL_LINE_HEIGHT = 5.0;

    RouteViewHelper() {
    }

    public static boolean areApproximatelyEqual(LatLng firstLocation, LatLng secondLocation) {
        double epsilonSq = 1.0E-6;
        float[] results = new float[1];
        Location.distanceBetween((double)firstLocation.latitude, (double)firstLocation.longitude, (double)secondLocation.latitude, (double)secondLocation.longitude, (float[])results);
        return (double)results[0] <= 1.0E-6;
    }

    public static boolean areCoordinateElevationPairApproximatelyEqual(LatLng latLngA, LatLng latLngB, Double perPointElevationA, Double perPointElevationB) {
        double elevationEpsilon = 0.001;
        if (!RouteViewHelper.areApproximatelyEqual(latLngA, latLngB)) {
            return false;
        }
        return Math.abs(perPointElevationA - perPointElevationB) < 0.001;
    }

    public static void removeCoincidentPoints(List<LatLng> coordinates) {
        if (coordinates == null) {
            return;
        }
        Iterator<LatLng> it = coordinates.iterator();
        LatLng prev = null;
        LatLng current = it.next();
        while (it.hasNext()) {
            prev = current;
            current = it.next();
            if (!RouteViewHelper.areApproximatelyEqual(current, prev)) continue;
            it.remove();
        }
    }

    public static void removeCoincidentPointsWithElevations(List<LatLng> coordinates, List<Double> perPointElevations) {
        Iterator<LatLng> coordinatesIt = coordinates.iterator();
        Iterator<Double> perPointIt = perPointElevations.iterator();
        LatLng prevLatLng = null;
        LatLng currentLatLng = coordinatesIt.next();
        Double prevPerPoint = null;
        Double currentPerPoint = perPointIt.next();
        while (coordinatesIt.hasNext() && perPointIt.hasNext()) {
            prevLatLng = currentLatLng;
            currentLatLng = coordinatesIt.next();
            prevPerPoint = currentPerPoint;
            currentPerPoint = perPointIt.next();
            if (!RouteViewHelper.areCoordinateElevationPairApproximatelyEqual(currentLatLng, prevLatLng, currentPerPoint, prevPerPoint)) continue;
            coordinatesIt.remove();
            perPointIt.remove();
        }
    }

    public static RoutingPolylineCreateParams makeNavRoutingPolylineCreateParams(List<LatLng> coordinates, boolean isForwardColor, String indoorId, int indoorFloorId) {
        return new RoutingPolylineCreateParams(coordinates, isForwardColor, indoorId, indoorFloorId, null);
    }

    public static RoutingPolylineCreateParams makeNavRoutingPolylineCreateParams(List<LatLng> coordinates, boolean isForwardColor, String indoorId, int indoorFloorId, double heightStart, double heightEnd) {
        return new RoutingPolylineCreateParams(coordinates, isForwardColor, indoorId, indoorFloorId, Arrays.asList(heightStart, heightEnd));
    }

    public static List<RoutingPolylineCreateParams> createLinesForRouteDirection(RouteStep routeStep, boolean isForwardColor) {
        ArrayList<RoutingPolylineCreateParams> results = new ArrayList<RoutingPolylineCreateParams>();
        ArrayList<LatLng> pathCoordinates = new ArrayList<LatLng>();
        pathCoordinates.addAll(routeStep.path);
        RouteViewHelper.removeCoincidentPoints(pathCoordinates);
        if (routeStep.path.size() > 1) {
            RoutingPolylineCreateParams polylineCreateParams = RouteViewHelper.makeNavRoutingPolylineCreateParams(pathCoordinates, isForwardColor, routeStep.indoorId, routeStep.indoorFloorId);
            results.add(polylineCreateParams);
        }
        return results;
    }

    public static List<RoutingPolylineCreateParams> createLinesForRouteDirection(RouteStep routeStep, int splitIndex, LatLng closestPointOnPath) {
        boolean hasReachedEnd;
        int coordinatesSize = routeStep.path.size();
        boolean bl = hasReachedEnd = splitIndex == routeStep.path.size() - 1;
        if (hasReachedEnd) {
            return RouteViewHelper.createLinesForRouteDirection(routeStep, false);
        }
        ArrayList<RoutingPolylineCreateParams> results = new ArrayList<RoutingPolylineCreateParams>();
        int forwardPathSize = coordinatesSize - (splitIndex + 1);
        int backwardPathSize = coordinatesSize - forwardPathSize;
        ArrayList<LatLng> forwardPath = new ArrayList<LatLng>(forwardPathSize);
        ArrayList<LatLng> backwardPath = new ArrayList<LatLng>(backwardPathSize);
        forwardPath.add(closestPointOnPath);
        for (int i = 0; i < coordinatesSize; ++i) {
            if (i <= splitIndex) {
                backwardPath.add(routeStep.path.get(i));
                continue;
            }
            forwardPath.add(routeStep.path.get(i));
        }
        backwardPath.add(closestPointOnPath);
        RouteViewHelper.removeCoincidentPoints(backwardPath);
        RouteViewHelper.removeCoincidentPoints(forwardPath);
        if (backwardPath.size() > 1) {
            results.add(RouteViewHelper.makeNavRoutingPolylineCreateParams(backwardPath, false, routeStep.indoorId, routeStep.indoorFloorId));
        }
        if (forwardPath.size() > 1) {
            results.add(RouteViewHelper.makeNavRoutingPolylineCreateParams(forwardPath, true, routeStep.indoorId, routeStep.indoorFloorId));
        }
        return results;
    }

    public static List<RoutingPolylineCreateParams> createLinesForFloorTransition(RouteStep routeStep, int floorBefore, int floorAfter, boolean isForwardColor) {
        double lineHeight = floorAfter > floorBefore ? 5.0 : -5.0;
        int coordinateCount = routeStep.path.size();
        ArrayList<LatLng> startCoords = new ArrayList<LatLng>(2);
        startCoords.add(routeStep.path.get(0));
        startCoords.add(routeStep.path.get(1));
        ArrayList<LatLng> endCoords = new ArrayList<LatLng>(2);
        endCoords.add(routeStep.path.get(coordinateCount - 2));
        endCoords.add(routeStep.path.get(coordinateCount - 1));
        ArrayList<RoutingPolylineCreateParams> results = new ArrayList<RoutingPolylineCreateParams>(2);
        results.add(RouteViewHelper.makeNavRoutingPolylineCreateParams(startCoords, isForwardColor, routeStep.indoorId, floorBefore, 0.0, lineHeight));
        results.add(RouteViewHelper.makeNavRoutingPolylineCreateParams(endCoords, isForwardColor, routeStep.indoorId, floorAfter, -lineHeight, 0.0));
        return results;
    }
}

