/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.indoorentities;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.indoorentities.IndoorMapEntity;
import com.eegeo.mapapi.indoorentities.IndoorMapEntityInformation;
import com.eegeo.mapapi.indoorentities.IndoorMapEntityLoadState;
import java.security.InvalidParameterException;

public class IndoorMapEntityInformationApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<IndoorMapEntityInformation> m_nativeHandleToIndoorMapEntityInformation = new SparseArray();

    public IndoorMapEntityInformationApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void register(IndoorMapEntityInformation indoorMapEntityInformation, IndoorMapEntityInformation.AllowHandleAccess allowHandleAccess) {
        int nativeHandle = indoorMapEntityInformation.getNativeHandle(allowHandleAccess);
        this.m_nativeHandleToIndoorMapEntityInformation.put(nativeHandle, (Object)indoorMapEntityInformation);
        this.fetchIndoorMapEntityInformation(nativeHandle);
    }

    @WorkerThread
    public int create(String indoorMapId, IndoorMapEntityInformation.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by IndoorMapEntityInformation");
        }
        return this.nativeCreateIndoorMapEntityInformation(this.m_jniEegeoMapApiPtr, indoorMapId);
    }

    @WorkerThread
    public void destroy(IndoorMapEntityInformation indoorMapEntityInformation, IndoorMapEntityInformation.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by IndoorMapEntityInformation");
        }
        int nativeHandle = indoorMapEntityInformation.getNativeHandle(allowHandleAccess);
        if (this.m_nativeHandleToIndoorMapEntityInformation.get(nativeHandle) != null) {
            this.nativeDestroyIndoorEntityInformation(this.m_jniEegeoMapApiPtr, nativeHandle);
            this.m_nativeHandleToIndoorMapEntityInformation.remove(nativeHandle);
        }
    }

    @WorkerThread
    public void notifyIndoorMapEntityInformationChanged(int nativeHandle) {
        if (this.m_nativeHandleToIndoorMapEntityInformation.get(nativeHandle) != null) {
            this.fetchIndoorMapEntityInformation(nativeHandle);
        }
    }

    @WorkerThread
    private void fetchIndoorMapEntityInformation(int nativeHandle) {
        final IndoorMapEntityInformation indoorMapEntityInformation = (IndoorMapEntityInformation)this.m_nativeHandleToIndoorMapEntityInformation.get(nativeHandle);
        if (indoorMapEntityInformation == null) {
            throw new NullPointerException("IndoorMapEntityInformation object not found for nativeHandle");
        }
        final IndoorMapEntity[] indoorMapEntities = this.nativeGetIndoorMapEntities(this.m_jniEegeoMapApiPtr, nativeHandle);
        final IndoorMapEntityLoadState indoorMapEntityLoadState = this.nativeGetIndoorMapEntityLoadState(this.m_jniEegeoMapApiPtr, nativeHandle);
        if (indoorMapEntities != null) {
            this.m_uiRunner.runOnUiThread(new Runnable(){

                @Override
                @UiThread
                public void run() {
                    indoorMapEntityInformation.updateFromNative(indoorMapEntities, indoorMapEntityLoadState);
                }
            });
        }
    }

    @WorkerThread
    private native int nativeCreateIndoorMapEntityInformation(long var1, String var3);

    @WorkerThread
    private native void nativeDestroyIndoorEntityInformation(long var1, int var3);

    @WorkerThread
    private native IndoorMapEntity[] nativeGetIndoorMapEntities(long var1, int var3);

    @WorkerThread
    private native IndoorMapEntityLoadState nativeGetIndoorMapEntityLoadState(long var1, int var3);
}

