/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.heatmaps;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.WeightedLatLngAlt;
import com.eegeo.mapapi.heatmaps.HeatmapApi;
import com.eegeo.mapapi.heatmaps.HeatmapOcclusionMapFeature;
import com.eegeo.mapapi.heatmaps.HeatmapOptions;
import com.eegeo.mapapi.polygons.PolygonOptions;
import com.eegeo.mapapi.util.NativeApiObject;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.concurrent.Callable;

public class Heatmap
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final HeatmapApi m_heatmapApi;
    private List<WeightedLatLngAlt> m_weightedPoints;
    private float[] m_heatmapDensityStops;
    private double[] m_heatmapRadii;
    private double[] m_heatmapGains;
    private float m_densityBlend;
    private boolean m_interpolateDensityByZoom;
    private double m_zoomMin;
    private double m_zoomMax;
    private double m_weightMin;
    private double m_weightMax;
    private float[] m_gradientStops;
    private int[] m_gradientColors;
    private float m_opacity;
    private int m_resolutionPixels;
    private float m_intensityBias;
    private float m_intensityScale;
    private String m_indoorMapId;
    private int m_indoorFloorId;
    private double m_elevation;
    private ElevationMode m_elevationMode;
    private HeatmapOcclusionMapFeature[] m_occludedMapFeatures;
    private float m_occludedStyleAlpha;
    private float m_occludedStyleSaturation;
    private float m_occludedStyleBrightness;
    private List<LatLng> m_polygonPoints;
    private List<List<LatLng>> m_polygonHoles;
    private float m_textureBorderPercent;
    private boolean m_useApproximation;

    @UiThread
    public Heatmap(final @NonNull HeatmapApi heatmapApi, final @NonNull HeatmapOptions heatmapOptions) {
        super(heatmapApi.getNativeRunner(), heatmapApi.getUiRunner(), new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return heatmapApi.create(heatmapOptions, m_allowHandleAccess);
            }
        });
        PolygonOptions polygonOptions = heatmapOptions.getPolygonOptions();
        this.m_heatmapApi = heatmapApi;
        this.m_weightedPoints = heatmapOptions.getWeightedPoints();
        this.m_heatmapDensityStops = heatmapOptions.getHeatmapDensityStops();
        this.m_heatmapRadii = heatmapOptions.getHeatmapRadii();
        this.m_heatmapGains = heatmapOptions.getHeatmapGains();
        this.m_densityBlend = heatmapOptions.getDensityBlend();
        this.m_interpolateDensityByZoom = heatmapOptions.getInterpolateDensityByZoom();
        this.m_zoomMin = heatmapOptions.getZoomMin();
        this.m_zoomMax = heatmapOptions.getZoomMax();
        this.m_weightMin = heatmapOptions.getWeightMin();
        this.m_weightMax = heatmapOptions.getWeightMax();
        this.m_gradientColors = heatmapOptions.getGradientColors();
        this.m_gradientStops = heatmapOptions.getGradientStops();
        this.m_opacity = heatmapOptions.getOpacity();
        this.m_resolutionPixels = heatmapOptions.getResolutionPixels();
        this.m_intensityBias = heatmapOptions.getIntensityBias();
        this.m_intensityScale = heatmapOptions.getIntensityScale();
        this.m_indoorMapId = polygonOptions.getIndoorMapId();
        this.m_indoorFloorId = polygonOptions.getIndoorFloorId();
        this.m_elevation = polygonOptions.getElevation();
        this.m_elevationMode = polygonOptions.getElevationMode();
        this.m_occludedStyleAlpha = heatmapOptions.getOccludedStyleAlpha();
        this.m_occludedStyleSaturation = heatmapOptions.getOccludedStyleSaturation();
        this.m_occludedStyleBrightness = heatmapOptions.getOccludedStyleBrightness();
        this.m_occludedMapFeatures = heatmapOptions.getOccludedMapFeatures();
        this.m_polygonPoints = polygonOptions.getPoints();
        this.m_polygonHoles = polygonOptions.getHoles();
        this.m_textureBorderPercent = heatmapOptions.getTextureBorderPercent();
        this.m_useApproximation = heatmapOptions.getUseApproximation();
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                heatmapApi.register(Heatmap.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    public List<WeightedLatLngAlt> getWeightedPoints() {
        return this.m_weightedPoints;
    }

    public float[] getHeatmapDensityStops() {
        return this.m_heatmapDensityStops;
    }

    public double[] getHeatmapRadii() {
        return this.m_heatmapRadii;
    }

    public double[] getHeatmapGains() {
        return this.m_heatmapGains;
    }

    public float getDensityBlend() {
        return this.m_densityBlend;
    }

    public boolean getInterpolateDensityByZoom() {
        return this.m_interpolateDensityByZoom;
    }

    public double getZoomMin() {
        return this.m_zoomMin;
    }

    public double getZoomMax() {
        return this.m_zoomMax;
    }

    public double getWeightMin() {
        return this.m_weightMin;
    }

    public double getWeightMax() {
        return this.m_weightMax;
    }

    public float[] getGradientStops() {
        return this.m_gradientStops;
    }

    public int[] getGradientColors() {
        return this.m_gradientColors;
    }

    public float getOpacity() {
        return this.m_opacity;
    }

    public int getResolutionPixels() {
        return this.m_resolutionPixels;
    }

    public float getIntensityBias() {
        return this.m_intensityBias;
    }

    public float getIntensityScale() {
        return this.m_intensityScale;
    }

    @UiThread
    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    @UiThread
    public int getIndoorFloorId() {
        return this.m_indoorFloorId;
    }

    @UiThread
    public double getElevation() {
        return this.m_elevation;
    }

    @UiThread
    public ElevationMode getElevationMode() {
        return this.m_elevationMode;
    }

    public HeatmapOcclusionMapFeature[] getOccludedMapFeatures() {
        return this.m_occludedMapFeatures;
    }

    public float getOccludedStyleAlpha() {
        return this.m_occludedStyleAlpha;
    }

    public float getOccludedStyleSaturation() {
        return this.m_occludedStyleSaturation;
    }

    public float getOccludedStyleBrightness() {
        return this.m_occludedStyleBrightness;
    }

    @UiThread
    public List<LatLng> getPolygonPoints() {
        return this.m_polygonPoints;
    }

    @UiThread
    public List<List<LatLng>> getPolygonHoles() {
        return this.m_polygonHoles;
    }

    public float getTextureBorderPercent() {
        return this.m_textureBorderPercent;
    }

    public boolean getUseApproximation() {
        return this.m_useApproximation;
    }

    public void setData(List<WeightedLatLngAlt> weightedPoints, double weightMin, double weightMax) {
        this.m_weightedPoints = weightedPoints;
        this.m_weightMin = weightMin;
        this.m_weightMax = weightMax;
        this.updateNativeData();
    }

    public void setDensityStops(float[] heatmapDensityStops, double[] heatmapRadiiMeters, double[] heatmapGains) {
        if (heatmapDensityStops.length == 0) {
            throw new InvalidParameterException("heatmapDensityStops must not be empty");
        }
        if (heatmapRadiiMeters.length != heatmapDensityStops.length) {
            throw new InvalidParameterException("heatmapRadiiMeters and stops must be equal length");
        }
        if (heatmapGains.length != heatmapDensityStops.length) {
            throw new InvalidParameterException("heatmapGains and stops must be equal length");
        }
        this.m_heatmapDensityStops = heatmapDensityStops;
        this.m_heatmapRadii = heatmapRadiiMeters;
        this.m_heatmapGains = heatmapGains;
        this.updateNativeHeatmapDensities();
    }

    public void setDensityBlend(float densityBlend) {
        this.m_densityBlend = Math.min(Math.max(densityBlend, 0.0f), 1.0f);
        this.updateNativeDensityBlend();
    }

    public void setInterpolateDensityByZoom(boolean interpolateDensityByZoom) {
        this.m_interpolateDensityByZoom = interpolateDensityByZoom;
        this.updateNativeInterpolateDensityByZoom();
    }

    public void setZoomExtents(double zoomMin, double zoomMax) {
        this.m_zoomMin = Math.max(zoomMin, 0.0);
        this.m_zoomMax = Math.max(zoomMax, 0.0);
        this.updateNativeInterpolateDensityByZoom();
    }

    public void setGradient(float[] gradientStops, int[] gradientColors) throws InvalidParameterException {
        if (gradientColors.length != gradientStops.length) {
            throw new InvalidParameterException("gradientColors and gradientStops must have same length");
        }
        this.m_gradientColors = gradientColors;
        this.m_gradientStops = gradientStops;
        this.updateNativeGradient();
    }

    public void setOpacity(float opacity) {
        this.m_opacity = Math.min(Math.max(opacity, 0.0f), 1.0f);
        this.updateNativeOpacity();
    }

    public void setResolutionPixels(int resolutionPixels) {
        this.m_resolutionPixels = Math.min(Math.max(resolutionPixels, HeatmapOptions.RESOLUTION_PIXELS_MIN), HeatmapOptions.RESOLUTION_PIXELS_MAX);
        this.updateNativeResolution();
    }

    public void setIntensityBias(float intensityBias) {
        this.m_intensityBias = Math.min(Math.max(intensityBias, 0.0f), 1.0f);
        this.updateNativeIntensityBias();
    }

    public void setIntensityScale(float intensityScale) {
        this.m_intensityScale = Math.max(intensityScale, 0.0f);
        this.updateNativeIntensityScale();
    }

    @UiThread
    public void setIndoorMapId(String indoorMapId) {
        this.m_indoorMapId = indoorMapId;
        this.updateNativeIndoorMap();
    }

    @UiThread
    public void setIndoorFloorId(int indoorFloorId) {
        this.m_indoorFloorId = indoorFloorId;
        this.updateNativeIndoorMap();
    }

    @UiThread
    public void setElevation(double elevation) {
        this.m_elevation = elevation;
        this.updateNativeElevation();
    }

    @UiThread
    public void setElevationMode(ElevationMode elevationMode) {
        this.m_elevationMode = elevationMode;
        this.updateNativeElevation();
    }

    public void setOccludedMapFeatures(HeatmapOcclusionMapFeature[] occludedMapFeatures) {
        this.m_occludedMapFeatures = occludedMapFeatures;
        this.updateNativeOccludedStyle();
    }

    public void setOccludedStyle(float alpha, float saturation, float brightness) {
        this.m_occludedStyleAlpha = Math.min(Math.max(alpha, 0.0f), 1.0f);
        this.m_occludedStyleSaturation = Math.min(Math.max(saturation, 0.0f), 1.0f);
        this.m_occludedStyleBrightness = Math.min(Math.max(brightness, 0.0f), 1.0f);
        this.updateNativeOccludedStyle();
    }

    public void setOccludedStyleAlpha(float alpha) {
        this.m_occludedStyleAlpha = Math.min(Math.max(alpha, 0.0f), 1.0f);
        this.updateNativeOccludedStyle();
    }

    public void setOccludedStyleSaturation(float saturation) {
        this.m_occludedStyleSaturation = Math.min(Math.max(saturation, 0.0f), 1.0f);
        this.updateNativeOccludedStyle();
    }

    public void setOccludedStyleBrightness(float brightness) {
        this.m_occludedStyleBrightness = Math.min(Math.max(brightness, 0.0f), 1.0f);
        this.updateNativeOccludedStyle();
    }

    public void setUseApproximation(boolean useApproximation) {
        this.m_useApproximation = useApproximation;
        this.updateNativeUseApproximation();
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.destroy(Heatmap.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    private void updateNativeIndoorMap() {
        final String indoorMapId = this.m_indoorMapId;
        final int indoorFloorId = this.m_indoorFloorId;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setIndoorMap(Heatmap.this.getNativeHandle(), m_allowHandleAccess, indoorMapId, indoorFloorId);
            }
        });
    }

    @UiThread
    private void updateNativeElevation() {
        final double elevation = this.m_elevation;
        final ElevationMode elevationMode = this.m_elevationMode;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setElevation(Heatmap.this.getNativeHandle(), m_allowHandleAccess, elevation, elevationMode);
            }
        });
    }

    @UiThread
    private void updateNativeDensityBlend() {
        final double densityBlend = this.m_densityBlend;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setDensityBlend(Heatmap.this.getNativeHandle(), m_allowHandleAccess, densityBlend);
            }
        });
    }

    @UiThread
    private void updateNativeInterpolateDensityByZoom() {
        final boolean interpolateDensityByZoom = this.m_interpolateDensityByZoom;
        final double zoomMin = this.m_zoomMin;
        final double zoomMax = this.m_zoomMax;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setInterpolateDensityByZoom(Heatmap.this.getNativeHandle(), m_allowHandleAccess, interpolateDensityByZoom, zoomMin, zoomMax);
            }
        });
    }

    @UiThread
    private void updateNativeIntensityBias() {
        final float intensityBias = this.m_intensityBias;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setIntensityBias(Heatmap.this.getNativeHandle(), m_allowHandleAccess, intensityBias);
            }
        });
    }

    @UiThread
    private void updateNativeIntensityScale() {
        final float intensityScale = this.m_intensityScale;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setIntensityScale(Heatmap.this.getNativeHandle(), m_allowHandleAccess, intensityScale);
            }
        });
    }

    @UiThread
    private void updateNativeOpacity() {
        final double opacity = this.m_opacity;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setOpacity(Heatmap.this.getNativeHandle(), m_allowHandleAccess, opacity);
            }
        });
    }

    @UiThread
    private void updateNativeGradient() {
        final float[] gradientStops = this.m_gradientStops;
        final int[] gradientColors = this.m_gradientColors;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setGradient(Heatmap.this.getNativeHandle(), m_allowHandleAccess, gradientStops, gradientColors);
            }
        });
    }

    @UiThread
    private void updateNativeOccludedStyle() {
        final HeatmapOcclusionMapFeature[] occludedFeatures = this.m_occludedMapFeatures;
        final float alpha = this.m_occludedStyleAlpha;
        final float saturation = this.m_occludedStyleSaturation;
        final float brightness = this.m_occludedStyleBrightness;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setOccludedStyle(Heatmap.this.getNativeHandle(), m_allowHandleAccess, occludedFeatures, alpha, saturation, brightness);
            }
        });
    }

    @UiThread
    private void updateNativeResolution() {
        final int resolutionPixels = this.m_resolutionPixels;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setResolution(Heatmap.this.getNativeHandle(), m_allowHandleAccess, resolutionPixels);
            }
        });
    }

    @UiThread
    private void updateNativeHeatmapDensities() {
        final float[] heatmapDensityStops = this.m_heatmapDensityStops;
        final double[] heatmapRadii = this.m_heatmapRadii;
        final double[] heatmapGains = this.m_heatmapGains;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setHeatmapDensities(Heatmap.this.getNativeHandle(), m_allowHandleAccess, heatmapDensityStops, heatmapRadii, heatmapGains);
            }
        });
    }

    @UiThread
    private void updateNativeUseApproximation() {
        boolean useApproximation = this.m_useApproximation;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setUseApproximation(Heatmap.this.getNativeHandle(), m_allowHandleAccess, Heatmap.this.m_useApproximation);
            }
        });
    }

    @UiThread
    private void updateNativeData() {
        final List<WeightedLatLngAlt> data = this.m_weightedPoints;
        final double weightMin = this.m_weightMin;
        final double weightMax = this.m_weightMax;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Heatmap.this.m_heatmapApi.setData(Heatmap.this.getNativeHandle(), m_allowHandleAccess, data, weightMin, weightMax);
            }
        });
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by HeatmapApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

