/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.precaching;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.precaching.OnPrecacheOperationCompletedListener;
import com.eegeo.mapapi.precaching.PrecacheApi;
import com.eegeo.mapapi.precaching.PrecacheOperationResult;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.concurrent.Callable;

public class PrecacheOperation
extends NativeApiObject {
    private OnPrecacheOperationCompletedListener m_callback;
    private PrecacheApi m_precacheApi;

    @UiThread
    PrecacheOperation(final @NonNull PrecacheApi precacheApi, final @NonNull LatLng center, final double radius, OnPrecacheOperationCompletedListener callback) {
        super(precacheApi.getNativeRunner(), precacheApi.getUiRunner(), new Callable<Integer>(){

            @Override
            public Integer call() {
                return precacheApi.beginPrecacheOperation(center, radius);
            }
        });
        this.m_callback = callback;
        this.m_precacheApi = precacheApi;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                PrecacheOperation.this.m_precacheApi.register(PrecacheOperation.this, PrecacheOperation.this.getNativeHandle());
            }
        });
    }

    @UiThread
    public void cancel() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                PrecacheOperation.this.m_precacheApi.cancelPrecacheOperation(PrecacheOperation.this.getNativeHandle());
            }
        });
    }

    @UiThread
    void returnResult(PrecacheOperationResult result) {
        if (this.m_callback != null) {
            this.m_callback.onPrecacheOperationCompleted(result);
        }
    }
}

