/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.heatmaps;

import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import android.util.SparseArray;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.geometry.ElevationMode;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.geometry.WeightedLatLngAlt;
import com.eegeo.mapapi.heatmaps.Heatmap;
import com.eegeo.mapapi.heatmaps.HeatmapOcclusionMapFeature;
import com.eegeo.mapapi.heatmaps.HeatmapOptions;
import com.eegeo.mapapi.polygons.PolygonOptions;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public class HeatmapApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;
    private SparseArray<Heatmap> m_nativeHandleToHeatmap = new SparseArray();

    public HeatmapApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @UiThread
    INativeMessageRunner getNativeRunner() {
        return this.m_nativeRunner;
    }

    @UiThread
    IUiMessageRunner getUiRunner() {
        return this.m_uiRunner;
    }

    @WorkerThread
    public void register(Heatmap heatmap, Heatmap.AllowHandleAccess allowHandleAccess) {
        this.m_nativeHandleToHeatmap.put(heatmap.getNativeHandle(allowHandleAccess), (Object)heatmap);
    }

    @WorkerThread
    public int create(HeatmapOptions heatmapOptions, Heatmap.AllowHandleAccess allowHandleAccess) throws InvalidParameterException {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        PolygonOptions polygonOptions = heatmapOptions.getPolygonOptions();
        if (!polygonOptions.getPoints().isEmpty() && polygonOptions.getPoints().size() < 3) {
            throw new InvalidParameterException("PolygonOptions points must either be empty or contain at least three elements");
        }
        List<LatLng> exteriorPoints = polygonOptions.getPoints();
        List<List<LatLng>> holes = polygonOptions.getHoles();
        int[] ringVertexCounts = this.buildRingVertexCounts(exteriorPoints, holes);
        double[] allPointsDoubleArray = this.buildPointsArray(exteriorPoints, holes, ringVertexCounts);
        double[] dataDoubleArray = this.weightedPointsToDoubleArray(heatmapOptions.getWeightedPoints());
        double weightMin = heatmapOptions.getWeightMin();
        double weightMax = heatmapOptions.getWeightMax();
        int resolutionPixels = heatmapOptions.getResolutionPixels();
        float textureBorderPercent = heatmapOptions.getTextureBorderPercent();
        float[] heatmapDensityStops = heatmapOptions.getHeatmapDensityStops();
        double[] heatmapRadiiArray = heatmapOptions.getHeatmapRadii();
        double[] heatmapGainsArray = heatmapOptions.getHeatmapGains();
        boolean useApproximation = heatmapOptions.getUseApproximation();
        float densityBlend = heatmapOptions.getDensityBlend();
        boolean interpolateDensityByZoom = heatmapOptions.getInterpolateDensityByZoom();
        double zoomMin = heatmapOptions.getZoomMin();
        double zoomMax = heatmapOptions.getZoomMax();
        float opacity = heatmapOptions.getOpacity();
        float intensityBias = heatmapOptions.getIntensityBias();
        float intensityScale = heatmapOptions.getIntensityScale();
        int occludedFeaturesInt = this.occludedMapFeaturesToInt(heatmapOptions.getOccludedMapFeatures());
        float occludedAlpha = heatmapOptions.getOccludedStyleAlpha();
        float occludedSaturation = heatmapOptions.getOccludedStyleSaturation();
        float occludedBrightness = heatmapOptions.getOccludedStyleBrightness();
        float[] gradientStopsArray = heatmapOptions.getGradientStops();
        int[] gradientColorsArray = heatmapOptions.getGradientColors();
        return this.nativeCreateHeatmap(this.m_jniEegeoMapApiPtr, polygonOptions.getIndoorMapId(), polygonOptions.getIndoorFloorId(), polygonOptions.getElevation(), polygonOptions.getElevationMode().ordinal(), allPointsDoubleArray, ringVertexCounts, dataDoubleArray, weightMin, weightMax, resolutionPixels, textureBorderPercent, heatmapDensityStops, heatmapRadiiArray, heatmapGainsArray, useApproximation, densityBlend, interpolateDensityByZoom, zoomMin, zoomMax, opacity, intensityBias, intensityScale, occludedFeaturesInt, occludedAlpha, occludedSaturation, occludedBrightness, gradientStopsArray, gradientColorsArray);
    }

    private double[] buildPointsArray(List<LatLng> exteriorPoints, List<List<LatLng>> holes, int[] ringVertexCounts) {
        int totalVertexCount = this.getTotalVertexCount(ringVertexCounts);
        ArrayList<LatLng> allPoints = new ArrayList<LatLng>(totalVertexCount);
        allPoints.addAll(exteriorPoints);
        for (List<LatLng> hole : holes) {
            allPoints.addAll(hole);
        }
        return this.latLngsToDoubleArray(allPoints);
    }

    private int getTotalVertexCount(int[] ringVertexCounts) {
        int totalVertexCount = 0;
        for (int vertexCount : ringVertexCounts) {
            totalVertexCount += vertexCount;
        }
        return totalVertexCount;
    }

    private int[] buildRingVertexCounts(List<LatLng> exteriorPoints, List<List<LatLng>> holes) {
        int allRingsCount = holes.size() + 1;
        int[] ringVertexCounts = new int[allRingsCount];
        ringVertexCounts[0] = exteriorPoints.size();
        for (int holeIndex = 0; holeIndex < holes.size(); ++holeIndex) {
            ringVertexCounts[holeIndex + 1] = holes.get(holeIndex).size();
        }
        return ringVertexCounts;
    }

    private double[] latLngsToDoubleArray(List<LatLng> points) {
        int pointCount = points.size();
        double[] coords = new double[pointCount * 2];
        for (int i = 0; i < pointCount; ++i) {
            coords[i * 2] = points.get((int)i).latitude;
            coords[i * 2 + 1] = points.get((int)i).longitude;
        }
        return coords;
    }

    private double[] weightedPointsToDoubleArray(List<WeightedLatLngAlt> weightedPoints) {
        int elementCount = weightedPoints.size();
        int doublesPerElement = 4;
        double[] doubles = new double[elementCount * 4];
        for (int i = 0; i < elementCount; ++i) {
            WeightedLatLngAlt element = weightedPoints.get(i);
            doubles[i * 4 + 0] = element.point.latitude;
            doubles[i * 4 + 1] = element.point.longitude;
            doubles[i * 4 + 2] = element.point.altitude;
            doubles[i * 4 + 3] = element.intensity;
        }
        return doubles;
    }

    @WorkerThread
    public void destroy(Heatmap heatmap, Heatmap.AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        int nativeHandle = heatmap.getNativeHandle(allowHandleAccess);
        if (this.m_nativeHandleToHeatmap.get(nativeHandle) != null) {
            this.nativeDestroyHeatmap(this.m_jniEegeoMapApiPtr, nativeHandle);
            this.m_nativeHandleToHeatmap.remove(nativeHandle);
        }
    }

    @WorkerThread
    void setIndoorMap(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, String indoorMapId, int indoorFloorId) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeSetIndoorMap(this.m_jniEegeoMapApiPtr, nativeHandle, indoorMapId, indoorFloorId);
    }

    @WorkerThread
    void setElevation(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, double elevation, ElevationMode elevationMode) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeSetElevation(this.m_jniEegeoMapApiPtr, nativeHandle, elevation, elevationMode.ordinal());
    }

    @WorkerThread
    void setDensityBlend(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, double densityBlend) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeDensityBlend(this.m_jniEegeoMapApiPtr, nativeHandle, densityBlend);
    }

    @WorkerThread
    void setInterpolateDensityByZoom(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, boolean interpolateDensityByZoom, double zoomMin, double zoomMax) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeInterpolateDensityByZoom(this.m_jniEegeoMapApiPtr, nativeHandle, interpolateDensityByZoom, zoomMin, zoomMax);
    }

    @WorkerThread
    void setIntensityBias(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, float intensityBias) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeIntensityBias(this.m_jniEegeoMapApiPtr, nativeHandle, intensityBias);
    }

    @WorkerThread
    void setIntensityScale(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, float intensityScale) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeIntensityScale(this.m_jniEegeoMapApiPtr, nativeHandle, intensityScale);
    }

    @WorkerThread
    void setOpacity(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, double opacity) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeOpacity(this.m_jniEegeoMapApiPtr, nativeHandle, (float)opacity);
    }

    @WorkerThread
    void setGradient(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, float[] gradientStops, int[] gradientColors) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeGradient(this.m_jniEegeoMapApiPtr, nativeHandle, gradientStops, gradientColors);
    }

    @WorkerThread
    private int occludedMapFeaturesToInt(HeatmapOcclusionMapFeature[] occludedMapFeatures) {
        int occludedMapFeaturesInt = 0;
        for (HeatmapOcclusionMapFeature occlusionFeature : occludedMapFeatures) {
            switch (occlusionFeature) {
                case ground: {
                    occludedMapFeaturesInt |= 1;
                }
                case buildings: {
                    occludedMapFeaturesInt |= 2;
                }
                case trees: {
                    occludedMapFeaturesInt |= 4;
                }
                case transport: {
                    occludedMapFeaturesInt |= 8;
                }
            }
        }
        return occludedMapFeaturesInt;
    }

    @WorkerThread
    void setOccludedStyle(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, HeatmapOcclusionMapFeature[] occludedFeatures, float occludedAlpha, float occludedSaturation, float occludedBrightness) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        int occludedFeaturesInt = this.occludedMapFeaturesToInt(occludedFeatures);
        this.nativeOccludedStyle(this.m_jniEegeoMapApiPtr, nativeHandle, occludedFeaturesInt, occludedAlpha, occludedSaturation, occludedBrightness);
    }

    @WorkerThread
    void setResolution(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, int resolutionPixels) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeResolution(this.m_jniEegeoMapApiPtr, nativeHandle, resolutionPixels);
    }

    @WorkerThread
    void setHeatmapDensities(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, float[] heatmapDensityStops, double[] heatmapRadii, double[] heatmapGains) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeHeatmapDensities(this.m_jniEegeoMapApiPtr, nativeHandle, heatmapDensityStops, heatmapRadii, heatmapGains);
    }

    @WorkerThread
    void setUseApproximation(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, boolean useApproximation) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        this.nativeUseApproximation(this.m_jniEegeoMapApiPtr, nativeHandle, useApproximation);
    }

    @WorkerThread
    void setData(int nativeHandle, Heatmap.AllowHandleAccess allowHandleAccess, List<WeightedLatLngAlt> weightedPoints, double weightMin, double weightMax) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for internal use by Heatmap");
        }
        double[] weightedPointsDoubleArray = this.weightedPointsToDoubleArray(weightedPoints);
        this.nativeSetData(this.m_jniEegeoMapApiPtr, nativeHandle, weightedPointsDoubleArray, weightMin, weightMax);
    }

    @WorkerThread
    private native int nativeCreateHeatmap(long var1, String var3, int var4, double var5, int var7, double[] var8, int[] var9, double[] var10, double var11, double var13, int var15, float var16, float[] var17, double[] var18, double[] var19, boolean var20, float var21, boolean var22, double var23, double var25, float var27, float var28, float var29, int var30, float var31, float var32, float var33, float[] var34, int[] var35);

    @WorkerThread
    private native void nativeDestroyHeatmap(long var1, int var3);

    @WorkerThread
    private native void nativeSetIndoorMap(long var1, int var3, String var4, int var5);

    @WorkerThread
    private native void nativeSetElevation(long var1, int var3, double var4, int var6);

    @WorkerThread
    private native void nativeDensityBlend(long var1, int var3, double var4);

    @WorkerThread
    private native void nativeInterpolateDensityByZoom(long var1, int var3, boolean var4, double var5, double var7);

    @WorkerThread
    private native void nativeIntensityBias(long var1, int var3, float var4);

    @WorkerThread
    private native void nativeIntensityScale(long var1, int var3, float var4);

    @WorkerThread
    private native void nativeOpacity(long var1, int var3, float var4);

    @WorkerThread
    private native void nativeGradient(long var1, int var3, float[] var4, int[] var5);

    @WorkerThread
    private native void nativeOccludedStyle(long var1, int var3, int var4, float var5, float var6, float var7);

    @WorkerThread
    private native void nativeResolution(long var1, int var3, int var4);

    @WorkerThread
    private native void nativeHeatmapDensities(long var1, int var3, float[] var4, double[] var5, double[] var6);

    @WorkerThread
    private native void nativeUseApproximation(long var1, int var3, boolean var4);

    @WorkerThread
    private native void nativeSetData(long var1, int var3, double[] var4, double var5, double var7);
}

