/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.indooroutlines;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.indooroutlines.IndoorMapFloorOutlineInformationApi;
import com.eegeo.mapapi.indooroutlines.IndoorMapFloorOutlinePolygon;
import com.eegeo.mapapi.indooroutlines.OnIndoorMapFloorOutlineInformationLoadedListener;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class IndoorMapFloorOutlineInformation
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final IndoorMapFloorOutlineInformationApi m_indoorMapFloorOutlineInformationApi;
    private final String m_indoorMapId;
    private final int m_indoorMapFloorId;
    private List<IndoorMapFloorOutlinePolygon> m_outlinePolygons;
    private boolean m_isLoaded;
    private OnIndoorMapFloorOutlineInformationLoadedListener m_onIndoorMapFloorOutlineInformationLoadedListener;

    @UiThread
    public IndoorMapFloorOutlineInformation(final @NonNull IndoorMapFloorOutlineInformationApi indoorMapFloorOutlineInformationApi, final @NonNull String indoorMapId, final @NonNull int indoorMapFloorId, OnIndoorMapFloorOutlineInformationLoadedListener indoorMapFloorOutlineInformationLoadedListener) {
        super(indoorMapFloorOutlineInformationApi.getNativeRunner(), indoorMapFloorOutlineInformationApi.getUiRunner(), new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return indoorMapFloorOutlineInformationApi.create(indoorMapId, indoorMapFloorId, m_allowHandleAccess);
            }
        });
        this.m_indoorMapFloorOutlineInformationApi = indoorMapFloorOutlineInformationApi;
        this.m_indoorMapId = indoorMapId;
        this.m_indoorMapFloorId = indoorMapFloorId;
        this.m_outlinePolygons = new ArrayList<IndoorMapFloorOutlinePolygon>();
        this.m_isLoaded = false;
        this.m_onIndoorMapFloorOutlineInformationLoadedListener = indoorMapFloorOutlineInformationLoadedListener;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                IndoorMapFloorOutlineInformation.this.m_indoorMapFloorOutlineInformationApi.register(IndoorMapFloorOutlineInformation.this, m_allowHandleAccess);
            }
        });
    }

    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    public int getIndoorMapFloorId() {
        return this.m_indoorMapFloorId;
    }

    public List<IndoorMapFloorOutlinePolygon> getIndoorMapFloorOutlinePolygons() {
        return this.m_outlinePolygons;
    }

    public boolean isLoaded() {
        return this.m_isLoaded;
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                IndoorMapFloorOutlineInformation.this.m_indoorMapFloorOutlineInformationApi.destroy(IndoorMapFloorOutlineInformation.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    void updateFromNative(IndoorMapFloorOutlinePolygon[] indoorMapFloorOutlinePolygons) {
        this.m_outlinePolygons = Arrays.asList(indoorMapFloorOutlinePolygons);
        this.m_isLoaded = true;
        if (this.m_onIndoorMapFloorOutlineInformationLoadedListener != null) {
            this.m_onIndoorMapFloorOutlineInformationLoadedListener.onIndoorMapFloorOutlineInformationLoaded(this);
        }
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by BuildingsApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

