/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.camera;

import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.INativeMessageRunner;
import com.eegeo.mapapi.IUiMessageRunner;
import com.eegeo.mapapi.camera.CameraAnimationOptions;
import com.eegeo.mapapi.camera.CameraPosition;
import com.eegeo.mapapi.camera.CameraUpdate;
import com.eegeo.mapapi.camera.CameraUpdateFactory;
import com.eegeo.mapapi.geometry.LatLngBounds;

public class CameraApi {
    private INativeMessageRunner m_nativeRunner;
    private IUiMessageRunner m_uiRunner;
    private long m_jniEegeoMapApiPtr;

    public CameraApi(INativeMessageRunner nativeRunner, IUiMessageRunner uiRunner, long jniEegeoMapApiPtr) {
        this.m_nativeRunner = nativeRunner;
        this.m_uiRunner = uiRunner;
        this.m_jniEegeoMapApiPtr = jniEegeoMapApiPtr;
    }

    @WorkerThread
    public void moveCamera(@NonNull CameraUpdate update) {
        switch (update.getUpdateType()) {
            case CameraPosition: {
                this.performMoveCamera((CameraUpdateFactory.IdentityCameraPositionUpdate)update);
                break;
            }
            case LatLngBounds: {
                this.performMoveCamera((CameraUpdateFactory.LatLongBoundsCameraPositionUpdate)update);
            }
        }
    }

    @WorkerThread
    public void cancelAnimation() {
        CameraApi.nativeCancelAnimation(this.m_jniEegeoMapApiPtr);
    }

    @WorkerThread
    public void animateCamera(@NonNull CameraUpdate update, CameraAnimationOptions animationOptions) {
        switch (update.getUpdateType()) {
            case CameraPosition: {
                this.performAnimateCamera((CameraUpdateFactory.IdentityCameraPositionUpdate)update, animationOptions);
                break;
            }
            case LatLngBounds: {
                this.performAnimateCamera((CameraUpdateFactory.LatLongBoundsCameraPositionUpdate)update, animationOptions);
            }
        }
    }

    @WorkerThread
    public void setIndoorCameraRestriction(Boolean indoorCameraRestriction) {
        CameraApi.nativeSetIndoorCameraRestriction(this.m_jniEegeoMapApiPtr, indoorCameraRestriction);
    }

    @WorkerThread
    public void setCameraScreenSpaceOffset(float screenX, float screenY) {
        CameraApi.nativeSetCameraScreenSpaceOffset(this.m_jniEegeoMapApiPtr, screenX, screenY);
    }

    @WorkerThread
    public void disableCameraScreenSpaceOffset() {
        CameraApi.nativeDisableCameraScreenSpaceOffset(this.m_jniEegeoMapApiPtr);
    }

    @WorkerThread
    private void performMoveCamera(@NonNull CameraUpdateFactory.IdentityCameraPositionUpdate cameraPositionUpdate) {
        CameraPosition cameraPosition = cameraPositionUpdate.getCameraPosition();
        CameraApi.nativeMoveCameraIdentityCameraPositionUpdate(this.m_jniEegeoMapApiPtr, cameraPosition);
    }

    @WorkerThread
    private void performMoveCamera(@NonNull CameraUpdateFactory.LatLongBoundsCameraPositionUpdate latLongBoundsUpdate) {
        LatLngBounds latLngBounds = latLongBoundsUpdate.getLatLngBounds();
        CameraApi.nativeMoveCameraLatLongBoundsCameraPositionUpdate(this.m_jniEegeoMapApiPtr, latLngBounds);
    }

    @WorkerThread
    private void performAnimateCamera(@NonNull CameraUpdateFactory.IdentityCameraPositionUpdate cameraPositionUpdate, CameraAnimationOptions animationOptions) {
        CameraPosition cameraPosition = cameraPositionUpdate.getCameraPosition();
        CameraApi.nativeAnimateCameraIdentityCameraPositionUpdate(this.m_jniEegeoMapApiPtr, cameraPosition, animationOptions);
    }

    @WorkerThread
    private void performAnimateCamera(@NonNull CameraUpdateFactory.LatLongBoundsCameraPositionUpdate latLongBoundsUpdate, CameraAnimationOptions animationOptions) {
        LatLngBounds latLngBounds = latLongBoundsUpdate.getLatLngBounds();
        CameraApi.nativeAnimateCameraLatLongBoundsCameraPositionUpdate(this.m_jniEegeoMapApiPtr, latLngBounds, animationOptions);
    }

    @WorkerThread
    private static native void nativeMoveCameraIdentityCameraPositionUpdate(long var0, CameraPosition var2);

    @WorkerThread
    private static native void nativeMoveCameraLatLongBoundsCameraPositionUpdate(long var0, LatLngBounds var2);

    @WorkerThread
    private static native void nativeAnimateCameraIdentityCameraPositionUpdate(long var0, CameraPosition var2, CameraAnimationOptions var3);

    @WorkerThread
    private static native void nativeAnimateCameraLatLongBoundsCameraPositionUpdate(long var0, LatLngBounds var2, CameraAnimationOptions var3);

    @WorkerThread
    private static native void nativeCancelAnimation(long var0);

    @WorkerThread
    private static native void nativeSetIndoorCameraRestriction(long var0, boolean var2);

    @WorkerThread
    private static native void nativeSetCameraScreenSpaceOffset(long var0, float var2, float var3);

    @WorkerThread
    private static native void nativeDisableCameraScreenSpaceOffset(long var0);
}

