/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.indoorentities;

import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.eegeo.mapapi.indoorentities.IndoorMapEntity;
import com.eegeo.mapapi.indoorentities.IndoorMapEntityInformationApi;
import com.eegeo.mapapi.indoorentities.IndoorMapEntityLoadState;
import com.eegeo.mapapi.indoorentities.OnIndoorMapEntityInformationChangedListener;
import com.eegeo.mapapi.util.NativeApiObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class IndoorMapEntityInformation
extends NativeApiObject {
    private static final AllowHandleAccess m_allowHandleAccess = new AllowHandleAccess();
    private final IndoorMapEntityInformationApi m_indoorMapEntityInformationApi;
    private final String m_indoorMapId;
    private List<IndoorMapEntity> m_indoorMapEntities;
    private IndoorMapEntityLoadState m_indoorMapEntityLoadState;
    private OnIndoorMapEntityInformationChangedListener m_indoorMapEntityInformationChangedListener;

    @UiThread
    public IndoorMapEntityInformation(final @NonNull IndoorMapEntityInformationApi indoorMapEntityInformationApi, final @NonNull String indoorMapId, OnIndoorMapEntityInformationChangedListener indoorMapEntityInformationChangedListener) {
        super(indoorMapEntityInformationApi.getNativeRunner(), indoorMapEntityInformationApi.getUiRunner(), new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return indoorMapEntityInformationApi.create(indoorMapId, m_allowHandleAccess);
            }
        });
        this.m_indoorMapEntityInformationApi = indoorMapEntityInformationApi;
        this.m_indoorMapId = indoorMapId;
        this.m_indoorMapEntities = new ArrayList<IndoorMapEntity>();
        this.m_indoorMapEntityLoadState = IndoorMapEntityLoadState.None;
        this.m_indoorMapEntityInformationChangedListener = indoorMapEntityInformationChangedListener;
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                IndoorMapEntityInformation.this.m_indoorMapEntityInformationApi.register(IndoorMapEntityInformation.this, m_allowHandleAccess);
            }
        });
    }

    public String getIndoorMapId() {
        return this.m_indoorMapId;
    }

    public List<IndoorMapEntity> getIndoorMapEntities() {
        return this.m_indoorMapEntities;
    }

    public IndoorMapEntityLoadState getLoadState() {
        return this.m_indoorMapEntityLoadState;
    }

    @UiThread
    public void destroy() {
        this.submit(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                IndoorMapEntityInformation.this.m_indoorMapEntityInformationApi.destroy(IndoorMapEntityInformation.this, m_allowHandleAccess);
            }
        });
    }

    @UiThread
    void updateFromNative(IndoorMapEntity[] indoorMapEntities, IndoorMapEntityLoadState indoorMapEntityLoadState) {
        this.m_indoorMapEntities = Arrays.asList(indoorMapEntities);
        this.m_indoorMapEntityLoadState = indoorMapEntityLoadState;
        if (this.m_indoorMapEntityInformationChangedListener != null) {
            this.m_indoorMapEntityInformationChangedListener.onIndoorMapEntityInformationChanged(this);
        }
    }

    @WorkerThread
    int getNativeHandle(AllowHandleAccess allowHandleAccess) {
        if (allowHandleAccess == null) {
            throw new NullPointerException("Null access token. Method is intended for use by BuildingsApi");
        }
        if (!this.hasNativeHandle()) {
            throw new IllegalStateException("Native handle not available");
        }
        return this.getNativeHandle();
    }

    static final class AllowHandleAccess {
        @WorkerThread
        private AllowHandleAccess() {
        }
    }
}

