/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.heatmaps;

import com.eegeo.mapapi.geometry.WeightedLatLngAlt;
import com.eegeo.mapapi.heatmaps.HeatmapOcclusionMapFeature;
import com.eegeo.mapapi.polygons.PolygonOptions;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HeatmapOptions {
    private List<WeightedLatLngAlt> m_weightedPoints = new ArrayList<WeightedLatLngAlt>();
    private List<Float> m_heatmapDensityStops = new ArrayList<Float>();
    private List<Double> m_heatmapRadii = new ArrayList<Double>();
    private List<Double> m_heatmapGains = new ArrayList<Double>();
    private float m_densityBlend = 0.0f;
    private boolean m_interpolateDensityByZoom = false;
    private double m_zoomMin = 15.0;
    private double m_zoomMax = 18.0;
    private double m_weightMin = 0.0;
    private double m_weightMax = 1.0;
    private float[] m_gradientStops = new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
    private int[] m_gradientColors = new int[]{-256, -17769985, -36926721, -57845249, -481676289, -1291845377};
    private float m_opacity = 1.0f;
    private int m_resolutionPixels = 512;
    private float m_intensityBias = 0.0f;
    private float m_intensityScale = 1.0f;
    private PolygonOptions m_polygonOptions = new PolygonOptions();
    private float m_occludedAlpha = 0.85f;
    private float m_occludedSaturation = 0.7f;
    private float m_occludedBrightness = 0.7f;
    private HeatmapOcclusionMapFeature[] m_occludedMapFeatures = new HeatmapOcclusionMapFeature[]{HeatmapOcclusionMapFeature.buildings, HeatmapOcclusionMapFeature.trees};
    private float m_textureBorderPercent = 0.05f;
    private boolean m_useApproximation = true;
    public static int RESOLUTION_PIXELS_MIN = 32;
    public static int RESOLUTION_PIXELS_MAX = 2048;

    public HeatmapOptions add(WeightedLatLngAlt ... data) {
        Collections.addAll(this.m_weightedPoints, data);
        return this;
    }

    public HeatmapOptions add(WeightedLatLngAlt data) {
        this.m_weightedPoints.add(data);
        return this;
    }

    public HeatmapOptions heatmapRadius(double heatmapRadiusMeters) {
        this.m_heatmapDensityStops.clear();
        this.m_heatmapRadii.clear();
        this.m_heatmapGains.clear();
        this.m_heatmapDensityStops.add(Float.valueOf(0.0f));
        this.m_heatmapRadii.add(heatmapRadiusMeters);
        this.m_heatmapGains.add(1.0);
        return this;
    }

    public HeatmapOptions addDensityStop(float stop, double heatmapRadiusMeters, double heatmapGain) {
        this.m_heatmapDensityStops.add(Float.valueOf(stop));
        this.m_heatmapRadii.add(heatmapRadiusMeters);
        this.m_heatmapGains.add(heatmapGain);
        return this;
    }

    public HeatmapOptions setDensityStops(float[] stops, double[] heatmapRadiiMeters, double[] heatmapGains) {
        this.m_heatmapDensityStops.clear();
        this.m_heatmapRadii.clear();
        this.m_heatmapGains.clear();
        if (stops.length == 0) {
            throw new InvalidParameterException("stops must not be empty");
        }
        if (heatmapRadiiMeters.length != stops.length) {
            throw new InvalidParameterException("heatmapRadiiMeters and stops must be equal length");
        }
        if (heatmapGains.length != stops.length) {
            throw new InvalidParameterException("heatmapGains and stops must be equal length");
        }
        for (int i = 0; i < stops.length; ++i) {
            this.m_heatmapDensityStops.add(Float.valueOf(stops[i]));
            this.m_heatmapRadii.add(heatmapRadiiMeters[i]);
            this.m_heatmapGains.add(heatmapGains[i]);
        }
        return this;
    }

    public HeatmapOptions weightMin(double weightMin) {
        this.m_weightMin = weightMin;
        return this;
    }

    public HeatmapOptions weightMax(double weightMax) {
        this.m_weightMax = weightMax;
        return this;
    }

    public HeatmapOptions densityBlend(float densityBlend) {
        this.m_densityBlend = Math.min(Math.max(densityBlend, 0.0f), 1.0f);
        this.m_interpolateDensityByZoom = false;
        return this;
    }

    public HeatmapOptions interpolateDensityByZoom(double zoomMin, double zoomMax) {
        this.m_interpolateDensityByZoom = true;
        this.m_zoomMin = Math.max(zoomMin, 0.0);
        this.m_zoomMax = Math.max(zoomMax, 0.0);
        return this;
    }

    public HeatmapOptions gradient(float[] stops, int[] colors) {
        if (stops.length != colors.length) {
            throw new InvalidParameterException("gradient stops and colors arrays must be equal length");
        }
        this.m_gradientStops = stops;
        this.m_gradientColors = colors;
        return this;
    }

    public HeatmapOptions opacity(float opacity) {
        this.m_opacity = Math.min(Math.max(opacity, 0.0f), 1.0f);
        return this;
    }

    public HeatmapOptions resolutionPixels(int resolutionPixels) {
        this.m_resolutionPixels = Math.min(Math.max(resolutionPixels, RESOLUTION_PIXELS_MIN), RESOLUTION_PIXELS_MAX);
        return this;
    }

    public HeatmapOptions polygon(PolygonOptions polygonOptions) {
        this.m_polygonOptions = polygonOptions;
        return this;
    }

    public HeatmapOptions intensityBias(float intensityBias) {
        this.m_intensityBias = Math.min(Math.max(intensityBias, 0.0f), 1.0f);
        return this;
    }

    public HeatmapOptions intensityScale(float intensityScale) {
        this.m_intensityScale = Math.max(intensityScale, 0.0f);
        return this;
    }

    public HeatmapOptions occludedMapFeatures(HeatmapOcclusionMapFeature[] occludedMapFeatures) {
        this.m_occludedMapFeatures = occludedMapFeatures;
        return this;
    }

    public HeatmapOptions occludedStyleAlpha(float occludedAlpha) {
        this.m_occludedAlpha = Math.min(Math.max(occludedAlpha, 0.0f), 1.0f);
        return this;
    }

    public HeatmapOptions occludedStyleSaturation(float occludedSaturation) {
        this.m_occludedSaturation = Math.min(Math.max(occludedSaturation, 0.0f), 1.0f);
        return this;
    }

    public HeatmapOptions occludedStyleBrightness(float occludedBrightness) {
        this.m_occludedBrightness = Math.min(Math.max(occludedBrightness, 0.0f), 1.0f);
        return this;
    }

    public HeatmapOptions textureBorder(float textureBorderPercent) {
        this.m_textureBorderPercent = Math.min(Math.max(textureBorderPercent, 0.0f), 0.5f);
        return this;
    }

    public HeatmapOptions useApproximation(boolean useApproximation) {
        this.m_useApproximation = useApproximation;
        return this;
    }

    public List<WeightedLatLngAlt> getWeightedPoints() {
        return this.m_weightedPoints;
    }

    public float[] getHeatmapDensityStops() {
        float[] stops = new float[this.m_heatmapDensityStops.size()];
        for (int i = 0; i < this.m_heatmapDensityStops.size(); ++i) {
            stops[i] = Float.valueOf(this.m_heatmapDensityStops.get(i).floatValue()).floatValue();
        }
        return stops;
    }

    public double[] getHeatmapRadii() {
        double[] heatmapRadii = new double[this.m_heatmapRadii.size()];
        for (int i = 0; i < this.m_heatmapRadii.size(); ++i) {
            heatmapRadii[i] = this.m_heatmapRadii.get(i);
        }
        return heatmapRadii;
    }

    public double[] getHeatmapGains() {
        double[] heatmapGains = new double[this.m_heatmapGains.size()];
        for (int i = 0; i < this.m_heatmapGains.size(); ++i) {
            heatmapGains[i] = this.m_heatmapGains.get(i);
        }
        return heatmapGains;
    }

    public float getDensityBlend() {
        return this.m_densityBlend;
    }

    public boolean getInterpolateDensityByZoom() {
        return this.m_interpolateDensityByZoom;
    }

    public double getZoomMin() {
        return this.m_zoomMin;
    }

    public double getZoomMax() {
        return this.m_zoomMax;
    }

    public double getWeightMin() {
        return this.m_weightMin;
    }

    public double getWeightMax() {
        return this.m_weightMax;
    }

    public float[] getGradientStops() {
        return this.m_gradientStops;
    }

    public int[] getGradientColors() {
        return this.m_gradientColors;
    }

    public float getOpacity() {
        return this.m_opacity;
    }

    public int getResolutionPixels() {
        return this.m_resolutionPixels;
    }

    public float getIntensityBias() {
        return this.m_intensityBias;
    }

    public float getIntensityScale() {
        return this.m_intensityScale;
    }

    public PolygonOptions getPolygonOptions() {
        return this.m_polygonOptions;
    }

    public float getOccludedStyleAlpha() {
        return this.m_occludedAlpha;
    }

    public float getOccludedStyleSaturation() {
        return this.m_occludedSaturation;
    }

    public float getOccludedStyleBrightness() {
        return this.m_occludedBrightness;
    }

    public HeatmapOcclusionMapFeature[] getOccludedMapFeatures() {
        return this.m_occludedMapFeatures;
    }

    public float getTextureBorderPercent() {
        return this.m_textureBorderPercent;
    }

    public boolean getUseApproximation() {
        return this.m_useApproximation;
    }
}

