/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.mapapi.widgets;

import android.support.annotation.UiThread;
import com.eegeo.mapapi.EegeoMap;
import com.eegeo.mapapi.geometry.LatLng;
import com.eegeo.mapapi.polylines.Polyline;
import com.eegeo.mapapi.polylines.PolylineOptions;
import com.eegeo.mapapi.services.routing.Route;
import com.eegeo.mapapi.services.routing.RouteSection;
import com.eegeo.mapapi.services.routing.RouteStep;
import com.eegeo.mapapi.widgets.RouteViewOptions;
import java.util.ArrayList;
import java.util.List;

public class RouteView {
    private static double VERTICAL_LINE_HEIGHT = 5.0;
    private EegeoMap m_map = null;
    private Route m_route = null;
    private List<Polyline> m_polylines = new ArrayList<Polyline>();
    private boolean m_currentlyOnMap = false;
    private float m_width;
    private int m_colorARGB;
    private float m_miterLimit;

    public RouteView(EegeoMap map, Route route, RouteViewOptions options) {
        this.m_map = map;
        this.m_route = route;
        this.m_width = options.getWidth();
        this.m_colorARGB = options.getColor();
        this.m_miterLimit = options.getMiterLimit();
        this.addToMap();
    }

    public void addToMap() {
        for (RouteSection section : this.m_route.sections) {
            List<RouteStep> steps = section.steps;
            for (int i = 0; i < steps.size(); ++i) {
                RouteStep step = steps.get(i);
                if (step.path.size() < 2) continue;
                if (step.isMultiFloor) {
                    boolean isValidTransition;
                    boolean bl = isValidTransition = i > 0 && i < steps.size() - 1 && step.isIndoors;
                    if (!isValidTransition) continue;
                    RouteStep stepBefore = steps.get(i - 1);
                    RouteStep stepAfter = steps.get(i + 1);
                    this.addLinesForFloorTransition(step, stepBefore, stepAfter);
                    continue;
                }
                this.addLinesForRouteStep(step);
            }
        }
        this.m_currentlyOnMap = true;
    }

    private PolylineOptions basePolylineOptions() {
        return new PolylineOptions().color(this.m_colorARGB).width(this.m_width).miterLimit(this.m_miterLimit);
    }

    private Polyline makeVerticalLine(RouteStep step, int floor, double height) {
        PolylineOptions options = this.basePolylineOptions().indoor(step.indoorId, floor).add(step.path.get(0), 0.0).add(step.path.get(1), height);
        return this.m_map.addPolyline(options);
    }

    private void addLinesForRouteStep(RouteStep step) {
        PolylineOptions options = this.basePolylineOptions();
        if (step.isIndoors) {
            options.indoor(step.indoorId, step.indoorFloorId);
        }
        for (LatLng point : step.path) {
            options.add(point);
        }
        Polyline routeLine = this.m_map.addPolyline(options);
        this.m_polylines.add(routeLine);
    }

    private void addLinesForFloorTransition(RouteStep step, RouteStep stepBefore, RouteStep stepAfter) {
        int floorAfter = stepAfter.indoorFloorId;
        int floorBefore = stepBefore.indoorFloorId;
        double lineHeight = floorAfter > floorBefore ? VERTICAL_LINE_HEIGHT : -VERTICAL_LINE_HEIGHT;
        this.m_polylines.add(this.makeVerticalLine(step, floorBefore, lineHeight));
        this.m_polylines.add(this.makeVerticalLine(step, floorAfter, -lineHeight));
    }

    public void removeFromMap() {
        for (Polyline polyline : this.m_polylines) {
            this.m_map.removePolyline(polyline);
        }
        this.m_currentlyOnMap = false;
    }

    @UiThread
    public void setWidth(float width) {
        this.m_width = width;
        for (Polyline polyline : this.m_polylines) {
            polyline.setWidth(this.m_width);
        }
    }

    @UiThread
    public void setColor(int color) {
        this.m_colorARGB = color;
        for (Polyline polyline : this.m_polylines) {
            polyline.setColor(this.m_colorARGB);
        }
    }

    @UiThread
    public void setMiterLimit(float miterLimit) {
        this.m_miterLimit = miterLimit;
        for (Polyline polyline : this.m_polylines) {
            polyline.setMiterLimit(this.m_miterLimit);
        }
    }
}

