/*
 * Decompiled with CFR 0.152.
 */
package com.eegeo.indoors;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ListView;

public class BackwardsCompatibleListView
extends ListView {
    private Rect m_clipBounds;
    private float m_itemHeight;

    public BackwardsCompatibleListView(Context context) {
        super(context);
    }

    public BackwardsCompatibleListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BackwardsCompatibleListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void draw(Canvas canvas) {
        if (this.m_clipBounds != null) {
            canvas.clipRect(this.m_clipBounds);
        }
        super.draw(canvas);
    }

    public void scrollListBy_compat(int y) {
        if (Build.VERSION.SDK_INT >= 19) {
            super.scrollListBy(y);
            return;
        }
        if (y != 0) {
            int item = (int)Math.floor((float)(y += this.getListScrollY()) / this.m_itemHeight);
            int scroll = (int)((float)item * this.m_itemHeight - (float)y);
            this.smoothScrollToPositionFromTop(item, scroll, 0);
        }
    }

    public void setItemHeight(float height) {
        this.m_itemHeight = height;
    }

    public int getListScrollY() {
        if (super.getChildCount() == 0) {
            return 0;
        }
        View v = this.getChildAt(0);
        int tempscroll = (int)((float)this.getFirstVisiblePosition() * this.m_itemHeight - (float)v.getTop());
        return tempscroll;
    }

    public Rect getClipBounds_compat() {
        if (Build.VERSION.SDK_INT >= 18) {
            return super.getClipBounds();
        }
        return this.m_clipBounds != null ? new Rect(this.m_clipBounds) : null;
    }

    public void setClipBounds_compat(Rect clipBounds) {
        if (Build.VERSION.SDK_INT >= 18) {
            super.setClipBounds(clipBounds);
            return;
        }
        if (clipBounds != null) {
            if (clipBounds.equals((Object)this.m_clipBounds)) {
                return;
            }
            if (this.m_clipBounds == null) {
                this.invalidate();
                this.m_clipBounds = new Rect(clipBounds);
            } else {
                this.invalidate(Math.min(this.m_clipBounds.left, clipBounds.left), Math.min(this.m_clipBounds.top, clipBounds.top), Math.max(this.m_clipBounds.right, clipBounds.right), Math.max(this.m_clipBounds.bottom, clipBounds.bottom));
                this.m_clipBounds.set(clipBounds);
            }
        } else if (this.m_clipBounds != null) {
            this.invalidate();
            this.m_clipBounds = null;
        }
    }
}

