/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.sips.helper;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SortedReflectionToStringBuilder
extends ReflectionToStringBuilder {
    private Comparator<Field> comparator;

    public SortedReflectionToStringBuilder(Object object, ToStringStyle style) {
        super(object, style);
    }

    public void setComparator(Comparator<Field> comparator) {
        this.comparator = comparator;
    }

    protected void appendFieldsIn(Class<?> clazz) {
        if (clazz.isArray()) {
            this.reflectionAppendArray(this.getObject());
            return;
        }
        AccessibleObject[] fields = clazz.getDeclaredFields();
        if (this.comparator != null) {
            Arrays.sort(fields, this.comparator);
        }
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            String fieldName = ((Field)field).getName();
            if (!this.accept((Field)field)) continue;
            try {
                Object fieldValue = this.getValue((Field)field);
                if (this.isExcludeNullValues() && fieldValue == null) continue;
                this.append(fieldName, fieldValue);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
            }
        }
    }
}

