/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.UploadableFile;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class MultipartFormDataObject {
    private final String boundary = UUID.randomUUID().toString();
    private final String contentType = "multipart/form-data; boundary=" + this.boundary;
    private final Map<String, String> values = new LinkedHashMap<String, String>();
    private final Map<String, UploadableFile> files = new LinkedHashMap<String, UploadableFile>();

    public String getBoundary() {
        return this.boundary;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public Map<String, UploadableFile> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    public void addValue(String parameterName, String value) {
        if (parameterName == null || parameterName.trim().isEmpty()) {
            throw new IllegalArgumentException("parameterName is required");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is required");
        }
        if (this.values.containsKey(parameterName) || this.files.containsKey(parameterName)) {
            throw new IllegalArgumentException("duplicate parameterName: " + parameterName);
        }
        this.values.put(parameterName, value);
    }

    public void addFile(String parameterName, UploadableFile file) {
        if (parameterName == null || parameterName.trim().isEmpty()) {
            throw new IllegalArgumentException("parameterName is required");
        }
        if (file == null) {
            throw new IllegalArgumentException("file is required");
        }
        if (this.values.containsKey(parameterName) || this.files.containsKey(parameterName)) {
            throw new IllegalArgumentException("duplicate parameterName: " + parameterName);
        }
        this.files.put(parameterName, file);
    }
}

