/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import java.io.IOException;
import java.io.InputStream;

public class TrackingInputStream
extends InputStream {
    private final InputStream inner;
    private long position;

    public TrackingInputStream(InputStream inner) {
        this.inner = inner;
    }

    @Override
    public int read() throws IOException {
        return this.inner.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.inner.read(b);
        if (read != -1) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inner.read(b, off, len);
        if (read != -1) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        this.position += n;
        return super.skip(n);
    }

    public long getPosition() {
        return this.position;
    }
}

