/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import com.worksap.nlp.sudachi.dictionary.build.ModelOutput;
import com.worksap.nlp.sudachi.dictionary.build.WriteDictionary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class Parameters
implements WriteDictionary {
    private ByteBuffer data;
    private ShortBuffer params;
    private int maxLeft = Integer.MAX_VALUE;
    private int maxRight = Integer.MAX_VALUE;

    public Parameters(int initialSize) {
        this.data = ByteBuffer.allocate(initialSize);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.params = this.data.asShortBuffer();
    }

    public Parameters() {
        this(0x100000);
    }

    public void add(short left, short right, short cost) {
        this.maybeResize();
        if (left >= this.maxLeft) {
            throw new IllegalArgumentException(String.format("left %d is larger than max value %d", left, this.maxLeft));
        }
        if (right >= this.maxRight) {
            throw new IllegalArgumentException(String.format("right %d is larger than max value %d", right, this.maxRight));
        }
        this.params.put(left);
        this.params.put(right);
        this.params.put(cost);
    }

    public void setLimits(int left, int right) {
        this.maxLeft = left;
        this.maxRight = right;
    }

    private void maybeResize() {
        if (this.params.remaining() < 3) {
            ByteBuffer newData = ByteBuffer.allocate(this.data.capacity() * 2);
            newData.order(ByteOrder.LITTLE_ENDIAN);
            int position = this.params.position();
            this.data.position(0);
            this.data.limit(position * 2);
            newData.put(this.data);
            newData.clear();
            this.data = newData;
            this.params = newData.asShortBuffer();
            this.params.position(position);
            assert (this.params.remaining() > 3);
        }
    }

    @Override
    public void writeTo(ModelOutput output) throws IOException {
        output.withPart("word parameters", () -> {
            this.data.limit(this.params.position() * 2);
            output.write(this.data);
        });
    }
}

