/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.POS;
import com.worksap.nlp.sudachi.dictionary.build.DicBuffer;
import com.worksap.nlp.sudachi.dictionary.build.ModelOutput;
import com.worksap.nlp.sudachi.dictionary.build.WriteDictionary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class POSTable
implements WriteDictionary {
    private final List<POS> table = new ArrayList<POS>();
    private final HashMap<POS, Short> lookup = new HashMap();
    private int builtin = 0;

    short getId(POS s) {
        return this.lookup.computeIfAbsent(s, p -> {
            int next = this.table.size();
            if (next >= Short.MAX_VALUE) {
                throw new IllegalArgumentException("maximum POS number exceeded by " + s);
            }
            this.table.add(s);
            return (short)next;
        });
    }

    public void preloadFrom(Grammar grammar) {
        short s = grammar.getPartOfSpeechSize();
        for (short i = 0; i < s; i = (short)(i + 1)) {
            POS pos = grammar.getPartOfSpeechString(i);
            this.table.add(pos);
            this.lookup.put(pos, i);
        }
        this.builtin += s;
    }

    List<POS> getList() {
        return this.table;
    }

    @Override
    public void writeTo(ModelOutput output) throws IOException {
        output.withPart("POS table", () -> {
            DicBuffer buffer = new DicBuffer(131072);
            buffer.putShort((short)this.ownedLength());
            for (int i = this.builtin; i < this.table.size(); ++i) {
                for (String s : this.table.get(i)) {
                    if (buffer.put(s)) continue;
                    buffer.consume(output::write);
                    buffer.put(s);
                }
            }
            buffer.consume(output::write);
        });
    }

    public int ownedLength() {
        return this.table.size() - this.builtin;
    }
}

