/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import com.worksap.nlp.sudachi.dictionary.build.Progress;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

public class ModelOutput
implements SeekableByteChannel {
    private final SeekableByteChannel internal;
    private final List<Part> parts = new ArrayList<Part>();
    private Progress progressor;

    public ModelOutput(SeekableByteChannel internal) {
        this.internal = internal;
    }

    public void progressor(Progress progress) {
        this.progressor = progress;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.internal.read(byteBuffer);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.internal.write(byteBuffer);
    }

    @Override
    public long position() throws IOException {
        return this.internal.position();
    }

    @Override
    public SeekableByteChannel position(long l) throws IOException {
        return this.internal.position(l);
    }

    @Override
    public long size() throws IOException {
        return this.internal.size();
    }

    @Override
    public SeekableByteChannel truncate(long l) throws IOException {
        return this.internal.truncate(l);
    }

    @Override
    public boolean isOpen() {
        return this.internal.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.internal.close();
    }

    public void withPart(String name, IORunnable inner) throws IOException {
        long pos = this.position();
        long start = System.nanoTime();
        if (this.progressor != null) {
            this.progressor.startBlock(name, start, Progress.Kind.OUTPUT);
        }
        inner.run();
        long time = System.nanoTime() - start;
        long size = this.position() - pos;
        if (this.progressor != null) {
            this.progressor.endBlock(size, time);
        }
        this.parts.add(new Part(name, time, size));
    }

    public void withSizedPart(String name, SizedRunnable inner) throws IOException {
        long start = System.nanoTime();
        if (this.progressor != null) {
            this.progressor.startBlock(name, start, Progress.Kind.OUTPUT);
        }
        long size = inner.run();
        long time = System.nanoTime() - start;
        if (this.progressor != null) {
            this.progressor.endBlock(size, time);
        }
        this.parts.add(new Part(name, time, size));
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void progress(long current, long max) {
        if (this.progressor != null) {
            this.progressor.progress(current, max);
        }
    }

    public static class Part {
        private final String name;
        private final long time;
        private final long size;

        public Part(String name, long time, long size) {
            this.name = name;
            this.time = time;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public long getTime() {
            return this.time;
        }

        public long getSize() {
            return this.size;
        }
    }

    @FunctionalInterface
    static interface SizedRunnable {
        public long run() throws IOException;
    }

    @FunctionalInterface
    static interface IORunnable {
        public void run() throws IOException;
    }
}

