/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary.build;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DicBuffer {
    public static final int MAX_STRING = Short.MAX_VALUE;
    private final ByteBuffer buffer;

    public DicBuffer(int length, int number) {
        this(length * number * 2 + number * 2);
    }

    public DicBuffer(int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static boolean isValidLength(String text) {
        return text.length() <= Short.MAX_VALUE;
    }

    public boolean put(String s) {
        int length = s.length();
        if (!this.putLength(length)) {
            return false;
        }
        s.chars().forEach(c -> this.buffer.putChar((char)c));
        return true;
    }

    public boolean putLength(int length) {
        int addLen;
        if (length >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("can't handle string with length >= 32767");
        }
        int n = addLen = length > 127 ? 2 : 1;
        if (this.wontFit(length * 2 + addLen)) {
            return false;
        }
        if (length <= 127) {
            this.buffer.put((byte)length);
        } else {
            this.buffer.put((byte)(length >> 8 | 0x80));
            this.buffer.put((byte)(length & 0xFF));
        }
        return true;
    }

    public <T> T consume(IOConsumer<T> consumer) throws IOException {
        this.buffer.flip();
        T result = consumer.accept(this.buffer);
        this.buffer.clear();
        return result;
    }

    public void putShort(short val) {
        this.buffer.putShort(val);
    }

    public void putInt(int val) {
        this.buffer.putInt(val);
    }

    public boolean wontFit(int space) {
        return this.buffer.remaining() < space;
    }

    public int position() {
        return this.buffer.position();
    }

    public void putEmptyIfEqual(String field, String surface) {
        if (field.equals(surface)) {
            this.put("");
        } else {
            this.put(field);
        }
    }

    public void putInts(int[] data) {
        this.buffer.put((byte)data.length);
        for (int v : data) {
            this.buffer.putInt(v);
        }
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public T accept(ByteBuffer var1) throws IOException;
    }
}

