/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class WordParameterList {
    private static final int ELEMENT_SIZE = 6;
    private ByteBuffer bytes;
    private final int size;
    private int offset;
    private boolean isCopied;

    WordParameterList(ByteBuffer bytes, int offset) {
        this.bytes = bytes;
        this.size = bytes.getInt(offset);
        this.offset = offset + 4;
        this.isCopied = false;
    }

    int storageSize() {
        return 4 + 6 * this.size;
    }

    int size() {
        return this.size;
    }

    short getLeftId(int wordId) {
        return this.bytes.getShort(this.offset + 6 * wordId);
    }

    short getRightId(int wordId) {
        return this.bytes.getShort(this.offset + 6 * wordId + 2);
    }

    short getCost(int wordId) {
        return this.bytes.getShort(this.offset + 6 * wordId + 4);
    }

    void setCost(int wordId, short cost) {
        if (!this.isCopied) {
            this.copyBuffer();
        }
        this.bytes.putShort(this.offset + 6 * wordId + 4, cost);
    }

    int endOffset() {
        return this.offset + 4 + 6 * this.size;
    }

    synchronized void copyBuffer() {
        ByteBuffer srcBuffer;
        ByteBuffer newBuffer = ByteBuffer.allocate(6 * this.size);
        newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer buffer = srcBuffer = this.bytes.duplicate();
        ((Buffer)buffer).position(this.offset);
        ((Buffer)buffer).limit(this.offset + 6 * this.size);
        newBuffer.put(srcBuffer);
        this.bytes = newBuffer;
        this.offset = 0;
        this.isCopied = true;
    }
}

