/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.WordId;
import com.worksap.nlp.sudachi.dictionary.WordLookup;
import java.nio.ByteBuffer;

class WordIdTable {
    private final ByteBuffer bytes;
    private final int size;
    private final int offset;
    private int dicIdMask = 0;

    WordIdTable(ByteBuffer bytes, int offset) {
        this.bytes = bytes;
        this.size = bytes.getInt(offset);
        this.offset = offset + 4;
    }

    int storageSize() {
        return 4 + this.size;
    }

    Integer[] get(int index) {
        int length = Byte.toUnsignedInt(this.bytes.get(this.offset + index++));
        Integer[] result = new Integer[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.bytes.getInt(this.offset + index);
            index += 4;
        }
        return result;
    }

    int readWordIds(int index, WordLookup lookup) {
        int offset = this.offset + index;
        ByteBuffer bytes = this.bytes;
        int length = Byte.toUnsignedInt(bytes.get(offset));
        ++offset;
        int[] result = lookup.outputBuffer(length);
        int dicIdMask = this.dicIdMask;
        for (int i = 0; i < length; ++i) {
            int wordId = bytes.getInt(offset);
            result[i] = WordId.applyMask(wordId, dicIdMask);
            offset += 4;
        }
        return length;
    }

    void setDictionaryId(int id) {
        this.dicIdMask = WordId.dicIdMask(id);
    }
}

