/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.BinaryDictionary;
import com.worksap.nlp.sudachi.dictionary.DictionaryBuilder;
import com.worksap.nlp.sudachi.dictionary.build.DicBuilder;
import com.worksap.nlp.sudachi.dictionary.build.Progress;
import java.io.Console;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;

public class UserDictionaryBuilder {
    static void printUsage() {
        Console console = System.console();
        console.printf("usage: UserDictionaryBuilder -o file -s file [-d description] files...\n", new Object[0]);
        console.printf("\t-o file\toutput to file\n", new Object[0]);
        console.printf("\t-s file\tsystem dictionary\n", new Object[0]);
        console.printf("\t-d description\tcomment\n", new Object[0]);
    }

    public static void main(String[] args) throws IOException {
        int i;
        String description = "";
        Path outputPath = null;
        String sysDictPath = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-o") && i + 1 < args.length) {
                outputPath = Paths.get(args[++i], new String[0]);
                continue;
            }
            if (args[i].equals("-s") && i + 1 < args.length) {
                sysDictPath = args[++i];
                continue;
            }
            if (args[i].equals("-d") && i + 1 < args.length) {
                description = args[++i];
                continue;
            }
            if (!args[i].equals("-h")) break;
            UserDictionaryBuilder.printUsage();
            return;
        }
        if (args.length <= i || outputPath == null || sysDictPath == null) {
            UserDictionaryBuilder.printUsage();
            return;
        }
        List<String> lexiconPaths = Arrays.asList(args).subList(i, args.length);
        try (BinaryDictionary system = new BinaryDictionary(sysDictPath);){
            DicBuilder.User builder = (DicBuilder.User)((DicBuilder.User)DicBuilder.user(system).description(description)).progress(new Progress(20, new DictionaryBuilder.StderrProgress()));
            for (String lexicon : lexiconPaths) {
                builder.lexicon(Paths.get(lexicon, new String[0]));
            }
            try (SeekableByteChannel channel = Files.newByteChannel(outputPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                builder.build(channel);
            }
        }
    }
}

