/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.WordId;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.Lexicon;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import com.worksap.nlp.sudachi.dictionary.WordLookup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LexiconSet
implements Lexicon {
    static final int MAX_DICTIONARIES = 15;
    List<DoubleArrayLexicon> lexicons = new ArrayList<DoubleArrayLexicon>();
    final short systemPartOfSpeechSize;
    List<Short> posOffsets = new ArrayList<Short>();

    public LexiconSet(Lexicon systemLexicon, short systemPartOfSpeechSize) {
        this.systemPartOfSpeechSize = systemPartOfSpeechSize;
        this.add(systemLexicon, (short)0);
    }

    public void add(Lexicon lexicon, short posOffset) {
        DoubleArrayLexicon daLexicon = (DoubleArrayLexicon)lexicon;
        daLexicon.setDictionaryId(this.lexicons.size());
        this.lexicons.add(daLexicon);
        this.posOffsets.add(posOffset);
    }

    public boolean isFull() {
        return this.lexicons.size() >= 15;
    }

    @Override
    public Iterator<int[]> lookup(byte[] text, int offset) {
        if (this.lexicons.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (this.lexicons.size() == 1) {
            return this.lexicons.get(0).lookup(text, offset);
        }
        return new Itr(text, offset, this.lexicons.size() - 1);
    }

    @Override
    public int getWordId(String headword, short posId, String readingForm) {
        for (int dictId = 1; dictId < this.lexicons.size(); ++dictId) {
            int wid = this.lexicons.get(dictId).getWordId(headword, posId, readingForm);
            if (wid < 0) continue;
            return this.buildWordId(dictId, wid);
        }
        return this.lexicons.get(0).getWordId(headword, posId, readingForm);
    }

    @Override
    public short getLeftId(int wordId) {
        return this.lexicons.get(WordId.dic(wordId)).getLeftId(LexiconSet.getWordId(wordId));
    }

    @Override
    public short getRightId(int wordId) {
        return this.lexicons.get(WordId.dic(wordId)).getRightId(LexiconSet.getWordId(wordId));
    }

    @Override
    public short getCost(int wordId) {
        return this.lexicons.get(WordId.dic(wordId)).getCost(LexiconSet.getWordId(wordId));
    }

    @Override
    public WordInfo getWordInfo(int wordId) {
        int dictionaryId = WordId.dic(wordId);
        int internalId = WordId.word(wordId);
        WordInfo wordInfo = this.lexicons.get(dictionaryId).getWordInfo(internalId);
        short posId = wordInfo.getPOSId();
        if (dictionaryId > 0 && posId >= this.systemPartOfSpeechSize) {
            wordInfo.setPOSId((short)(wordInfo.getPOSId() - this.systemPartOfSpeechSize + this.posOffsets.get(dictionaryId)));
        }
        this.convertSplit(wordInfo.getAunitSplit(), dictionaryId);
        this.convertSplit(wordInfo.getBunitSplit(), dictionaryId);
        this.convertSplit(wordInfo.getWordStructure(), dictionaryId);
        return wordInfo;
    }

    @Override
    public int size() {
        return this.lexicons.stream().mapToInt(Lexicon::size).sum();
    }

    private static int getWordId(int wordId) {
        return WordId.word(wordId);
    }

    private int buildWordId(int dictId, int wordId) {
        if (dictId >= this.lexicons.size()) {
            throw new IndexOutOfBoundsException("dictionaryId is too large: " + dictId);
        }
        return WordId.make(dictId, wordId);
    }

    private void convertSplit(int[] split, int dictionaryId) {
        for (int i = 0; i < split.length; ++i) {
            if (WordId.dic(split[i]) <= 0) continue;
            split[i] = this.buildWordId(dictionaryId, LexiconSet.getWordId(split[i]));
        }
    }

    public WordLookup makeLookup() {
        return new WordLookup(this.lexicons);
    }

    private class Itr
    implements Iterator<int[]> {
        byte[] text;
        int offset;
        int dictId;
        Iterator<int[]> iterator;

        Itr(byte[] text, int offset, int start) {
            this.text = text;
            this.offset = offset;
            this.dictId = start;
            this.iterator = LexiconSet.this.lexicons.get(this.dictId).lookup(text, offset);
        }

        @Override
        public boolean hasNext() {
            while (!this.iterator.hasNext()) {
                int nextId = this.dictId - 1;
                if (nextId < 0) {
                    return false;
                }
                this.iterator = LexiconSet.this.lexicons.get(nextId).lookup(this.text, this.offset);
                this.dictId = nextId;
            }
            return true;
        }

        @Override
        public int[] next() {
            if (this.hasNext()) {
                int[] r = this.iterator.next();
                r[0] = LexiconSet.this.buildWordId(this.dictId, r[0]);
                return r;
            }
            throw new NoSuchElementException();
        }
    }
}

