/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import java.nio.IntBuffer;

public final class DoubleArrayLookup {
    private IntBuffer array;
    private byte[] key;
    private int limit;
    private int startOffset;
    private int offset;
    private int nodePos;
    private int nodeValue;

    public DoubleArrayLookup() {
        this(null);
    }

    public DoubleArrayLookup(IntBuffer array) {
        this.array = array;
    }

    public DoubleArrayLookup(IntBuffer array, byte[] key, int offset, int limit) {
        this(array);
        this.reset(key, offset, limit);
    }

    private static boolean hasLeaf(int unit) {
        return (unit >>> 8 & 1) == 1;
    }

    private static int value(int unit) {
        return unit & Integer.MAX_VALUE;
    }

    private static int label(int unit) {
        return unit & 0x800000FF;
    }

    private static int offset(int unit) {
        return unit >>> 10 << ((unit & 0x200) >>> 6);
    }

    public void setArray(IntBuffer array) {
        this.array = array;
        this.reset(this.key, this.startOffset, this.limit);
    }

    public void reset(byte[] key, int offset, int limit) {
        this.key = key;
        this.offset = offset;
        this.startOffset = offset;
        this.limit = limit;
        this.nodePos = 0;
        int unit = this.array.get(this.nodePos);
        this.nodePos ^= DoubleArrayLookup.offset(unit);
    }

    public boolean next() {
        IntBuffer array = this.array;
        byte[] key = this.key;
        int nodePos = this.nodePos;
        int limit = this.limit;
        for (int offset = this.offset; offset < limit; ++offset) {
            int k = Byte.toUnsignedInt(key[offset]);
            int unit = array.get(nodePos ^= k);
            if (DoubleArrayLookup.label(unit) != k) {
                this.offset = limit;
                this.nodePos = nodePos;
                return false;
            }
            nodePos ^= DoubleArrayLookup.offset(unit);
            if (!DoubleArrayLookup.hasLeaf(unit)) continue;
            this.nodeValue = DoubleArrayLookup.value(array.get(nodePos));
            this.offset = offset + 1;
            this.nodePos = nodePos;
            return true;
        }
        return false;
    }

    public int getValue() {
        return this.nodeValue;
    }

    public int getOffset() {
        return this.offset;
    }
}

