/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVParser
implements Closeable {
    static final Token COMMA_TOKEN = new Token(Token.Type.COMMA, ",");
    static final Token DQUOTE_TOKEN = new Token(Token.Type.DQUOTE, "\"");
    static final Token NL_TOKEN = new Token(Token.Type.NL, "\n");
    static final Token EOF_TOKEN = new Token(Token.Type.EOF, null);
    static final Pattern TOKEN_PATTERN = Pattern.compile(",|\"|[^,\"]+");
    static final String INVALID_FORMAT_ERROR_MESSAGE = "invalid format";
    static final String UNKNOWN_ERROR_MESSAGE = "unknown error";
    private BufferedReader reader;
    private Deque<Token> tokenBuffer = new ArrayDeque<Token>();
    private boolean hasNextField = false;

    public CSVParser(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public List<String> getNextRecord() throws IOException {
        String field;
        ArrayList<String> record = new ArrayList<String>();
        this.hasNextField = false;
        while ((field = this.getField()) != null) {
            if (field.equals("\n")) {
                return record;
            }
            record.add(field);
        }
        return null;
    }

    private String getField() throws IOException {
        if (this.hasNextField) {
            return this.getNextField();
        }
        return this.getFirstField();
    }

    private String getFirstField() throws IOException {
        Token token = this.getToken();
        switch (token.type) {
            case COMMA: {
                this.hasNextField = true;
                return "";
            }
            case DQUOTE: {
                return this.getEscapedField();
            }
            case NL: {
                return "\n";
            }
            case TEXTDATA: {
                return this.getUnescapedField(token);
            }
            case EOF: {
                return null;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_ERROR_MESSAGE);
    }

    private String getNextField() throws IOException {
        Token token = this.getToken();
        switch (token.type) {
            case COMMA: {
                this.hasNextField = true;
                return "";
            }
            case DQUOTE: {
                return this.getEscapedField();
            }
            case NL: {
                this.hasNextField = false;
                this.ungetToken(NL_TOKEN);
                return "";
            }
            case TEXTDATA: {
                return this.getUnescapedField(token);
            }
            case EOF: {
                this.hasNextField = false;
                return "";
            }
        }
        throw new IllegalArgumentException(UNKNOWN_ERROR_MESSAGE);
    }

    private String getEscapedField() throws IOException {
        this.hasNextField = false;
        boolean isClosed = false;
        StringBuilder content = new StringBuilder();
        block7: while (true) {
            Token token = this.getToken();
            switch (token.type) {
                case NL: {
                    if (isClosed) {
                        this.ungetToken(token);
                        return content.toString();
                    }
                    content.append('\n');
                    continue block7;
                }
                case COMMA: {
                    if (isClosed) {
                        this.hasNextField = true;
                        return content.toString();
                    }
                    content.append(',');
                    continue block7;
                }
                case DQUOTE: {
                    if (isClosed) {
                        content.append('\"');
                        isClosed = false;
                        continue block7;
                    }
                    isClosed = true;
                    continue block7;
                }
                case TEXTDATA: {
                    if (isClosed) {
                        throw new IllegalArgumentException(INVALID_FORMAT_ERROR_MESSAGE);
                    }
                    content.append(token.content);
                    continue block7;
                }
                case EOF: {
                    if (!isClosed) {
                        throw new IllegalArgumentException(INVALID_FORMAT_ERROR_MESSAGE);
                    }
                    return null;
                }
            }
            break;
        }
        throw new IllegalArgumentException(UNKNOWN_ERROR_MESSAGE);
    }

    private String getUnescapedField(Token firstToken) throws IOException {
        this.hasNextField = false;
        StringBuilder content = new StringBuilder(firstToken.content);
        block6: while (true) {
            Token token = this.getToken();
            switch (token.type) {
                case COMMA: {
                    this.hasNextField = true;
                    return content.toString();
                }
                case NL: {
                    this.ungetToken(token);
                    return content.toString();
                }
                case TEXTDATA: {
                    content.append(token.content);
                    continue block6;
                }
                case EOF: {
                    return null;
                }
            }
            break;
        }
        throw new IllegalArgumentException(UNKNOWN_ERROR_MESSAGE);
    }

    private Token getToken() throws IOException {
        if (!this.tokenBuffer.isEmpty()) {
            return this.tokenBuffer.removeLast();
        }
        String line = this.reader.readLine();
        if (line == null) {
            return EOF_TOKEN;
        }
        Matcher matcher = TOKEN_PATTERN.matcher(line);
        while (matcher.find()) {
            String content = matcher.group();
            Token token = content.equals(",") ? COMMA_TOKEN : (content.equals("\"") ? DQUOTE_TOKEN : new Token(Token.Type.TEXTDATA, content));
            this.tokenBuffer.push(token);
        }
        this.tokenBuffer.push(NL_TOKEN);
        return this.tokenBuffer.removeLast();
    }

    private void ungetToken(Token token) {
        this.tokenBuffer.push(token);
    }

    static class Token {
        final Type type;
        final String content;

        Token(Type type, String content) {
            this.type = type;
            this.content = content;
        }

        static enum Type {
            COMMA,
            DQUOTE,
            NL,
            TEXTDATA,
            EOF;

        }
    }
}

