/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.Config;
import com.worksap.nlp.sudachi.MMap;
import com.worksap.nlp.sudachi.dictionary.DictionaryAccess;
import com.worksap.nlp.sudachi.dictionary.DictionaryHeader;
import com.worksap.nlp.sudachi.dictionary.DictionaryVersion;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BinaryDictionary
implements Closeable,
DictionaryAccess {
    private final ByteBuffer bytes;
    private final DictionaryHeader header;
    private final GrammarImpl grammar;
    private final DoubleArrayLexicon lexicon;

    public BinaryDictionary(String fileName) throws IOException {
        this(MMap.map(fileName));
    }

    public BinaryDictionary(ByteBuffer dictionary) throws IOException {
        int offset = 0;
        this.bytes = dictionary;
        this.header = new DictionaryHeader(this.bytes, offset);
        offset += this.header.storageSize();
        long version = this.header.getVersion();
        if (DictionaryVersion.hasGrammar(version)) {
            this.grammar = new GrammarImpl(this.bytes, offset);
            offset += this.grammar.storageSize();
        } else if (this.header.isUserDictionary()) {
            this.grammar = new GrammarImpl();
        } else {
            MMap.unmap(this.bytes);
            throw new IOException("invalid dictionary");
        }
        this.lexicon = new DoubleArrayLexicon(this.bytes, offset, DictionaryVersion.hasSynonymGroupIds(version));
    }

    public static BinaryDictionary loadSystem(String fileName) throws IOException {
        return BinaryDictionary.loadSystem(MMap.map(fileName));
    }

    public static BinaryDictionary loadUser(String fileName) throws IOException {
        return BinaryDictionary.loadUser(MMap.map(fileName));
    }

    public static BinaryDictionary loadSystem(ByteBuffer buffer) throws IOException {
        BinaryDictionary dict = new BinaryDictionary(buffer);
        if (!dict.getDictionaryHeader().isSystemDictionary()) {
            dict.close();
            throw new IOException("invalid system dictionary");
        }
        return dict;
    }

    public static BinaryDictionary loadUser(ByteBuffer buffer) throws IOException {
        BinaryDictionary dict = new BinaryDictionary(buffer);
        if (!dict.getDictionaryHeader().isUserDictionary()) {
            dict.close();
            throw new IOException("invalid user dictionary");
        }
        return dict;
    }

    public static BinaryDictionary loadSystem(Config.Resource<BinaryDictionary> resource) throws IOException {
        return resource.consume(res -> BinaryDictionary.loadSystem(res.asByteBuffer()));
    }

    public static BinaryDictionary loadUser(Config.Resource<BinaryDictionary> resource) throws IOException {
        return resource.consume(res -> BinaryDictionary.loadUser(res.asByteBuffer()));
    }

    @Override
    public void close() throws IOException {
        MMap.unmap(this.bytes);
    }

    public DictionaryHeader getDictionaryHeader() {
        return this.header;
    }

    @Override
    public GrammarImpl getGrammar() {
        return this.grammar;
    }

    @Override
    public DoubleArrayLexicon getLexicon() {
        return this.lexicon;
    }
}

