/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.MorphemeFormatterPlugin;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class WordSegmentationFormatter
extends MorphemeFormatterPlugin {
    @Override
    public void setUp() throws IOException {
        super.setUp();
        this.delimiter = this.settings.getString("delimiter", " ");
        this.eosString = this.settings.getString("eos", "\n");
    }

    @Override
    public String formatMorpheme(Morpheme morpheme) {
        return morpheme.surface();
    }

    @Override
    void printSentence(List<Morpheme> sentence, PrintStream output) {
        boolean isFirst = true;
        for (Morpheme m : sentence) {
            String morpheme = this.formatMorpheme(m);
            if (morpheme.equals("") || morpheme.equals(this.delimiter)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                output.print(this.delimiter);
            }
            output.print(morpheme);
        }
        output.print(this.eosString);
    }
}

