/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

public class WordId {
    public static final int MAX_WORD_ID = 0xFFFFFFF;
    public static final int MAX_DIC_ID = 14;

    private WordId() {
    }

    public static int makeUnchecked(int dic, int word) {
        int dicPart = WordId.dicIdMask(dic);
        return dicPart | word;
    }

    public static int make(int dic, int word) {
        if (word > 0xFFFFFFF) {
            throw new IndexOutOfBoundsException("wordId is too large: " + word);
        }
        if (dic > 14) {
            throw new IndexOutOfBoundsException("dictionaryId is too large: " + dic);
        }
        return WordId.makeUnchecked(dic, word);
    }

    public static int dic(int wordId) {
        return wordId >>> 28;
    }

    public static int word(int wordId) {
        return wordId & 0xFFFFFFF;
    }

    public static int dicIdMask(int dicId) {
        return dicId << 28;
    }

    public static int applyMask(int wordId, int dicIdMask) {
        return wordId & 0xFFFFFFF | dicIdMask;
    }
}

