/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Config;
import com.worksap.nlp.sudachi.Dictionary;
import com.worksap.nlp.sudachi.DictionaryFactory;
import com.worksap.nlp.sudachi.MorphemeFormatterPlugin;
import com.worksap.nlp.sudachi.PathAnchor;
import com.worksap.nlp.sudachi.Settings;
import com.worksap.nlp.sudachi.SimpleMorphemeFormatter;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.WordSegmentationFormatter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Function;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class SudachiCommandLine {
    static Logger logger = Logger.getLogger(SudachiCommandLine.class.getName());

    static void run(Tokenizer tokenizer, Tokenizer.SplitMode mode, InputStream input, PrintStream output, MorphemeFormatterPlugin formatter, boolean ignoreError, boolean isFileInput, boolean isWordSegmentation) throws IOException {
        try (InputStreamReader inputReader = isFileInput ? new InputStreamReader(input, StandardCharsets.UTF_8) : new InputStreamReader(input);
             BufferedReader reader = new BufferedReader(inputReader);){
            String line = reader.readLine();
            while (line != null) {
                try {
                    for (List list : tokenizer.tokenizeSentences(mode, line)) {
                        formatter.printSentence(list, output);
                    }
                    if (isWordSegmentation) {
                        output.print("\n");
                    }
                }
                catch (RuntimeException e) {
                    if (ignoreError) {
                        logger.warning(e.getMessage() + "\n");
                    }
                    throw e;
                }
                line = reader.readLine();
            }
        }
    }

    static MorphemeFormatterPlugin makeFormatter(boolean isWordSegmentation, boolean isLineBreakAtEosInWordSegmentation, String formatterKind, Settings settings) throws IOException {
        MorphemeFormatterPlugin formatter;
        if (settings == null) {
            settings = Settings.empty();
        }
        if (formatterKind != null) {
            formatter = SudachiCommandLine.instantiatePluginClass(formatterKind, settings);
        } else if (isWordSegmentation) {
            formatter = new WordSegmentationFormatter();
            formatter.setSettings(settings);
            formatter.setUp();
            if (isLineBreakAtEosInWordSegmentation) {
                formatter.setEosString("\n");
            } else {
                formatter.setEosString(" ");
            }
        } else {
            formatter = new SimpleMorphemeFormatter();
            formatter.setSettings(settings);
            formatter.setUp();
        }
        return formatter;
    }

    private static MorphemeFormatterPlugin instantiatePluginClass(String formatterKind, Settings settings) throws IOException {
        MorphemeFormatterPlugin formatter;
        try {
            Class<?> pluginClass = Class.forName(formatterKind);
            formatter = (MorphemeFormatterPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            formatter.setSettings(settings);
            formatter.setUp();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("failed to instantiate formatter " + formatterKind, e);
        }
        return formatter;
    }

    public static void main(String[] args) throws IOException {
        block49: {
            int i;
            InputStream is = SudachiCommandLine.class.getClassLoader().getResourceAsStream("sudachi.logging.properties");
            if (is != null) {
                LogManager logManager = LogManager.getLogManager();
                try {
                    MethodHandle updateConfiguration = MethodHandles.lookup().findVirtual(LogManager.class, "updateConfiguration", MethodType.methodType(Void.TYPE, InputStream.class, Function.class));
                    updateConfiguration.invoke(logManager, is, null);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    logManager.readConfiguration(is);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
            Tokenizer.SplitMode mode = Tokenizer.SplitMode.C;
            PathAnchor anchor = PathAnchor.classpath().andThen(PathAnchor.none());
            Settings current = Settings.resolvedBy(anchor).read(SudachiCommandLine.class.getClassLoader().getResource("sudachi.json"));
            Config additional = Config.empty();
            String outputFileName = null;
            boolean isEnableDump = false;
            boolean showDetails = false;
            boolean ignoreError = false;
            boolean isWordSegmentation = false;
            boolean isLineBreakAtEosInWordSegmentation = true;
            String formatterKind = null;
            for (i = 0; i < args.length; ++i) {
                Path resolved;
                if (args[i].equals("-r") && i + 1 < args.length) {
                    Path configPath;
                    Path parent;
                    if ((parent = (configPath = Paths.get(args[++i], new String[0])).getParent()) == null) {
                        parent = Paths.get("", new String[0]);
                    }
                    PathAnchor curAnchor = PathAnchor.filesystem(parent).andThen(PathAnchor.classpath());
                    additional = Config.fromFile(configPath, curAnchor).withFallback(additional);
                    continue;
                }
                if (args[i].equals("-p") && i + 1 < args.length) {
                    String resourcesDirectory = args[++i];
                    anchor = PathAnchor.filesystem(Paths.get(resourcesDirectory, new String[0])).andThen(PathAnchor.classpath());
                    current = Settings.resolvedBy(anchor).withFallback(current);
                    continue;
                }
                if (args[i].equals("-s") && i + 1 < args.length) {
                    Object other = Config.fromJsonString(args[++i], anchor);
                    additional = ((Config)other).withFallback(additional);
                    continue;
                }
                if (args[i].equals("-m") && i + 1 < args.length) {
                    switch (args[++i]) {
                        case "A": {
                            mode = Tokenizer.SplitMode.A;
                            break;
                        }
                        case "B": {
                            mode = Tokenizer.SplitMode.B;
                            break;
                        }
                        default: {
                            mode = Tokenizer.SplitMode.C;
                            break;
                        }
                    }
                    continue;
                }
                if (args[i].equals("-o") && i + 1 < args.length) {
                    outputFileName = args[++i];
                    continue;
                }
                if (args[i].equals("-a")) {
                    showDetails = true;
                    continue;
                }
                if (args[i].equals("-d")) {
                    isEnableDump = true;
                    continue;
                }
                if (args[i].equals("-f")) {
                    ignoreError = true;
                    continue;
                }
                if (args[i].equals("-t")) {
                    isWordSegmentation = true;
                    isLineBreakAtEosInWordSegmentation = false;
                    continue;
                }
                if (args[i].equals("-ts")) {
                    isWordSegmentation = true;
                    isLineBreakAtEosInWordSegmentation = true;
                    continue;
                }
                if (args[i].equals("-h")) {
                    PrintStream stderr = System.err;
                    stderr.print("usage: SudachiCommandLine [-r file] [-m A|B|C] [-o file] [file ...]\n");
                    stderr.print("\t-r file\tread settings from file (overrides -s)\n");
                    stderr.print("\t-s string\tadditional settings (overrides -r)\n");
                    stderr.print("\t-p directory\troot directory of resources\n");
                    stderr.print("\t-m mode\tmode of splitting\n");
                    stderr.print("\t-o file\toutput to file\n");
                    stderr.print("\t-t\tseparate words with spaces\n");
                    stderr.print("\t-ts\tseparate words with spaces, and break line for each sentence\n");
                    stderr.print("\t-a\tshow details\n");
                    stderr.print("\t-f\tignore error\n");
                    stderr.print("\t-d\tdebug mode\n");
                    stderr.print("\t--systemDict file\tpath to a system dictionary (overrides everything)\n");
                    stderr.print("\t--userDict file\tpath to an additional user dictionary (appended to -s)\n");
                    return;
                }
                if (args[i].equals("--userDict")) {
                    resolved = anchor.resolve(args[++i]);
                    logger.fine(() -> "using system dict: " + resolved);
                    additional = additional.addUserDictionary(resolved);
                    continue;
                }
                if (args[i].equals("--systemDict")) {
                    resolved = anchor.resolve(args[++i]);
                    logger.fine(() -> "using user dict: " + resolved);
                    additional = additional.systemDictionary(resolved);
                    continue;
                }
                if (!args[i].equals("--format")) break;
                formatterKind = args[++i];
            }
            Config config = additional.withFallback(Config.fromSettings(current));
            MorphemeFormatterPlugin formatter = SudachiCommandLine.makeFormatter(isWordSegmentation, isLineBreakAtEosInWordSegmentation, formatterKind, current);
            if (showDetails) {
                formatter.showDetails();
            }
            try (FileOrStdoutPrintStream output = outputFileName == null ? new FileOrStdoutPrintStream() : new FileOrStdoutPrintStream(outputFileName);
                 Dictionary dict = new DictionaryFactory().create(config);){
                Tokenizer tokenizer = dict.create();
                if (isEnableDump) {
                    tokenizer.setDumpOutput(output);
                }
                if (i < args.length) {
                    while (i < args.length) {
                        try (FileInputStream input = new FileInputStream(args[i]);){
                            SudachiCommandLine.run(tokenizer, mode, input, output, formatter, ignoreError, false, isWordSegmentation);
                        }
                        ++i;
                    }
                    break block49;
                }
                SudachiCommandLine.run(tokenizer, mode, System.in, output, formatter, ignoreError, true, isWordSegmentation);
            }
        }
    }

    static class FileOrStdoutPrintStream
    extends PrintStream {
        private boolean isFile;

        FileOrStdoutPrintStream() {
            super(System.out, true);
            this.isFile = false;
        }

        FileOrStdoutPrintStream(String fileName) throws FileNotFoundException, UnsupportedEncodingException {
            super((OutputStream)new FileOutputStream(fileName), false, "UTF-8");
            this.isFile = true;
        }

        @Override
        public void close() {
            if (this.isFile) {
                super.close();
            } else {
                this.flush();
            }
        }
    }
}

