/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;

public class StringUtil {
    private StringUtil() {
    }

    public static String readFully(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            String string = StringUtil.readFully(inputStream);
            return string;
        }
    }

    public static String readFully(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            String string = StringUtil.readFully(is);
            return string;
        }
    }

    public static String readFully(InputStream stream) throws IOException {
        InputStreamReader isr = new InputStreamReader(stream, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        CharBuffer cb = CharBuffer.allocate(1024);
        while (isr.read(cb) != -1) {
            cb.flip();
            sb.append(cb);
            cb.clear();
        }
        return sb.toString();
    }

    public static ByteBuffer readAllBytes(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            ByteBuffer byteBuffer = StringUtil.readAllBytes(is);
            return byteBuffer;
        }
    }

    public static ByteBuffer readAllBytes(InputStream inputStream) throws IOException {
        int nread;
        byte[] buffer = new byte[inputStream.available() + 1024];
        int offset = 0;
        while ((nread = inputStream.read(buffer, offset, buffer.length - offset)) >= 0) {
            if ((offset += nread) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        ByteBuffer bbuf = ByteBuffer.wrap(buffer);
        bbuf.limit(offset);
        return bbuf;
    }
}

