/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Config;
import com.worksap.nlp.sudachi.PathAnchor;
import com.worksap.nlp.sudachi.Plugin;
import com.worksap.nlp.sudachi.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;

public class Settings {
    private static final Logger logger = Logger.getLogger(Settings.class.getName());
    JsonObject root;
    PathAnchor base;

    Settings(JsonObject root, PathAnchor base) {
        this.root = Objects.requireNonNull(root);
        this.base = Objects.requireNonNull(base);
    }

    public static Settings empty() {
        return Settings.resolvedBy(PathAnchor.none());
    }

    public static Settings resolvedBy(PathAnchor resolver) {
        return new Settings(JsonObject.EMPTY_JSON_OBJECT, resolver);
    }

    public Settings read(Path file) throws IOException {
        logger.fine(() -> String.format("reading settings from %s", file));
        String data = StringUtil.readFully(file);
        Settings settings = Settings.parse(data, this.base);
        return settings.withFallback(this);
    }

    public Settings read(URL resource) throws IOException {
        logger.fine(() -> String.format("reading settings from %s", resource));
        String data = StringUtil.readFully(resource);
        Settings settings = Settings.parse(data, this.base);
        return settings.withFallback(this);
    }

    @Deprecated
    public static Settings parseSettings(String path, String json) {
        PathAnchor anchor = path == null ? PathAnchor.none() : PathAnchor.filesystem(Paths.get(path, new String[0]));
        anchor = anchor.andThen(PathAnchor.classpath());
        return Settings.parse(json, anchor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Settings parse(String json, PathAnchor resolver) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonStructure rootStr = reader.read();
            if (!(rootStr instanceof JsonObject)) throw new IllegalArgumentException("root must be an object");
            JsonObject root = (JsonObject)rootStr;
            String basePath = root.getString("path", null);
            if (basePath == null) {
                if (resolver == null) {
                    resolver = PathAnchor.none();
                }
                Settings settings = new Settings(root, resolver);
                return settings;
            }
            PathAnchor pathResolver = PathAnchor.filesystem(Paths.get(basePath, new String[0]));
            if (resolver != null) {
                pathResolver = pathResolver.andThen(resolver);
            }
            Settings settings = new Settings(root, pathResolver);
            return settings;
        }
        catch (JsonParsingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Settings fromFile(Path path) throws IOException {
        return Settings.fromFile(path, PathAnchor.filesystem(path.getParent()));
    }

    public static Settings fromFile(Path path, PathAnchor resolver) throws IOException {
        return Settings.resolvedBy(resolver).read(path);
    }

    public static Settings fromClasspath(URL url, PathAnchor resolver) throws IOException {
        return Settings.resolvedBy(resolver).read(url);
    }

    public String getString(String setting) {
        try {
            return this.root.getString(setting);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not a string", e);
        }
    }

    public String getString(String setting, String defaultValue) {
        return this.root.getString(setting, defaultValue);
    }

    public List<String> getStringList(String setting) {
        try {
            JsonArray array = this.root.getJsonArray(setting);
            if (array == null) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                result.add(array.getString(i));
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not an array of strings", e);
        }
    }

    public int getInt(String setting) {
        try {
            return this.root.getInt(setting);
        }
        catch (NullPointerException e) {
            return 0;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not a number", e);
        }
    }

    public int getInt(String setting, int defaultValue) {
        try {
            return this.root.getInt(setting, defaultValue);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not a number", e);
        }
    }

    public List<Integer> getIntList(String setting) {
        try {
            return this.getList(setting, JsonNumber.class).stream().map(JsonNumber::intValue).collect(Collectors.toList());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not an array of numbers", e);
        }
    }

    public List<List<Integer>> getIntListList(String setting) {
        try {
            return this.getList(setting, JsonArray.class).stream().map(a -> a.getValuesAs(JsonNumber.class).stream().map(JsonNumber::intValue).collect(Collectors.toList())).collect(Collectors.toList());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not an array of arrays of numbers", e);
        }
    }

    @Deprecated
    public String getPath(String setting) {
        Path resource = this.getPathObject(setting);
        if (resource == null) {
            return null;
        }
        return resource.toString();
    }

    @Deprecated
    public Path getPathObject(String setting) {
        String path = this.getString(setting);
        if (path == null) {
            return null;
        }
        return this.base.resolve(path);
    }

    public <T> Config.Resource<T> getResource(String setting) {
        String path = this.getString(setting);
        if (path == null) {
            return null;
        }
        return this.extractResource(path);
    }

    private <T> Config.Resource<T> extractResource(String path) {
        Path obj = this.base.resolve(path);
        return this.base.toResource(obj);
    }

    public <T> List<Config.Resource<T>> getResourceList(String setting) {
        List<String> list = this.getStringList(setting);
        if (list == null) {
            return null;
        }
        return list.stream().map(this::extractResource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<String> getPathList(String setting) {
        List<String> list = this.getStringList(setting);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(p -> this.base.resolve((String)p).toString()).collect(Collectors.toList());
    }

    public Boolean getBoolean(String setting, Boolean defaultValue) {
        try {
            return this.root.getBoolean(setting);
        }
        catch (ClassCastException | NullPointerException e) {
            return defaultValue;
        }
    }

    <E extends JsonValue> List<E> getList(String setting, Class<E> clazz) {
        JsonArray array = this.root.getJsonArray(setting);
        if (array == null) {
            return Collections.emptyList();
        }
        return array.getValuesAs(clazz);
    }

    <P extends Plugin> List<Config.PluginConf<P>> getPlugins(String name, Class<P> cls) {
        JsonArray array = this.root.getJsonArray(name);
        if (array == null) {
            return null;
        }
        ArrayList<Config.PluginConf<P>> result = new ArrayList<Config.PluginConf<P>>();
        for (JsonValue key : array) {
            JsonObject inner = key.asJsonObject();
            String className = inner.getString("class");
            if (className == null) {
                throw new IllegalArgumentException(String.format("sub-object for %s didn't have class key", name));
            }
            result.add(new Config.PluginConf<P>(className, new Settings(inner, this.base), cls));
        }
        return result;
    }

    @Deprecated
    public Settings merge(Settings settings) {
        return settings.withFallback(this);
    }

    public Settings withFallback(Settings other) {
        JsonObject merged = Settings.mergeObject(other.root, this.root);
        return new Settings(merged, this.base.andThen(other.base));
    }

    private static JsonObject mergeObject(JsonObject left, JsonObject right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder((JsonObject)right);
        for (String leftKey : left.keySet()) {
            JsonValue leftValue = (JsonValue)left.get((Object)leftKey);
            JsonValue rightValue = (JsonValue)right.get((Object)leftKey);
            if (rightValue == null) {
                builder.add(leftKey, leftValue);
                continue;
            }
            if (!(leftValue instanceof JsonObject) || !(rightValue instanceof JsonObject)) continue;
            builder.add(leftKey, (JsonValue)Settings.mergeObject((JsonObject)leftValue, (JsonObject)rightValue));
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings settings = (Settings)o;
        return this.root.equals(settings.root) && this.base.equals(settings.base);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.base);
    }
}

