/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.JapaneseTokenizer;
import com.worksap.nlp.sudachi.MorphemeList;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.UTF8InputText;
import com.worksap.nlp.sudachi.dictionary.LexiconSet;
import com.worksap.nlp.sudachi.sentdetect.SentenceDetector;
import java.util.ArrayList;
import java.util.Iterator;

class SentenceSplittingAnalysis
implements SentenceDetector.NonBreakCheker {
    private final SentenceDetector detector = new SentenceDetector();
    private final Tokenizer.SplitMode mode;
    private final JapaneseTokenizer tokenizer;
    final ArrayList<MorphemeList> result = new ArrayList();
    UTF8InputText input;
    int bos;

    SentenceSplittingAnalysis(Tokenizer.SplitMode mode, JapaneseTokenizer tokenizer) {
        this.mode = mode;
        this.tokenizer = tokenizer;
    }

    int tokenizeBuffer(CharSequence buffer) {
        int length;
        int bos;
        UTF8InputText input = this.tokenizer.buildInputText(buffer);
        String normalized = input.getText();
        this.input = input;
        this.bos = bos = 0;
        while ((length = this.detector.getEos(normalized, this)) > 0) {
            int eos = bos + length;
            if (eos < normalized.length()) {
                eos = input.getNextInOriginal(eos - 1);
                length = eos - bos;
            }
            UTF8InputText sentence = input.slice(bos, eos);
            this.result.add(this.tokenizer.tokenizeSentence(this.mode, sentence));
            normalized = normalized.substring(length);
            this.bos = bos = eos;
        }
        if (length < 0 && buffer.length() == -length) {
            this.result.add(this.tokenizer.tokenizeSentence(this.mode, input));
            return -length;
        }
        return length;
    }

    int bosPosition() {
        return this.input.textIndexToOriginalTextIndex(this.bos);
    }

    @Override
    public boolean hasNonBreakWord(int length) {
        UTF8InputText inp = this.input;
        int byteEOS = inp.getCodePointsOffsetLength(0, this.bos + length);
        byte[] bytes = inp.getByteText();
        LexiconSet lexicon = this.tokenizer.lexicon;
        for (int i = Math.max(0, byteEOS - 64); i < byteEOS; ++i) {
            Iterator<int[]> iterator = lexicon.lookup(bytes, i);
            while (iterator.hasNext()) {
                int[] r = iterator.next();
                int l = r[1];
                if (l <= byteEOS && (l != byteEOS || this.bos + length - inp.modifiedOffset(i) <= 1)) continue;
                return true;
            }
        }
        return false;
    }
}

