/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.JapaneseDictionary;
import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.MorphemeImpl;
import com.worksap.nlp.sudachi.dictionary.POS;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class PosMatcher
implements Predicate<Morpheme>,
Iterable<POS> {
    private final BitSet matching;
    private final JapaneseDictionary dictionary;

    public PosMatcher(int[] ids, JapaneseDictionary dictionary) {
        BitSet bits = new BitSet();
        for (int id : ids) {
            bits.set(id);
        }
        this.matching = bits;
        this.dictionary = dictionary;
    }

    private PosMatcher(BitSet data, JapaneseDictionary dictionary) {
        this.matching = data;
        this.dictionary = dictionary;
    }

    public PosMatcher union(PosMatcher other) {
        this.checkCompatibility(other);
        BitSet merged = new BitSet();
        merged.or(this.matching);
        merged.or(other.matching);
        return new PosMatcher(merged, this.dictionary);
    }

    public PosMatcher intersection(PosMatcher other) {
        this.checkCompatibility(other);
        BitSet merged = new BitSet();
        merged.or(this.matching);
        merged.and(other.matching);
        return new PosMatcher(merged, this.dictionary);
    }

    public PosMatcher invert() {
        int[] indices = IntStream.range(0, this.dictionary.getPartOfSpeechSize()).filter(idx -> !this.matching.get(idx)).toArray();
        return new PosMatcher(indices, this.dictionary);
    }

    private void checkCompatibility(PosMatcher other) {
        if (this.dictionary != other.dictionary) {
            throw new IllegalArgumentException("PosMatchers are using different dictionaries");
        }
    }

    @Override
    public boolean test(Morpheme morpheme) {
        assert (((MorphemeImpl)morpheme).list.grammar == this.dictionary.grammar);
        return this.matching.get(morpheme.partOfSpeechId());
    }

    @Override
    public Iterator<POS> iterator() {
        return new Iterator<POS>(){
            private int index;
            {
                this.index = PosMatcher.this.matching.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public POS next() {
                if (this.index < 0) {
                    throw new NoSuchElementException();
                }
                short posId = (short)this.index;
                POS result = PosMatcher.this.dictionary.getGrammar().getPartOfSpeechString(posId);
                this.index = PosMatcher.this.matching.nextSetBit(this.index + 1);
                return result;
            }
        };
    }
}

