/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.Plugin;
import com.worksap.nlp.sudachi.UTF8InputText;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import com.worksap.nlp.sudachi.dictionary.POS;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public abstract class OovProviderPlugin
extends Plugin {
    public static final String USER_POS = "userPOS";
    public static final String USER_POS_FORBID = "forbid";
    public static final String USER_POS_ALLOW = "allow";

    public void setUp(Grammar grammar) throws IOException {
    }

    public abstract int provideOOV(InputText var1, int var2, long var3, List<LatticeNodeImpl> var5);

    int getOOV(UTF8InputText inputText, int offset, long otherWords, List<LatticeNodeImpl> result) {
        int oldSize = result.size();
        int numCreated = this.provideOOV(inputText, offset, otherWords, result);
        for (int i = 0; i < numCreated; ++i) {
            LatticeNodeImpl n = result.get(oldSize + i);
            n.begin = offset;
            n.end = offset + n.getWordInfo().getLength();
        }
        return numCreated;
    }

    protected LatticeNodeImpl createNode() {
        LatticeNodeImpl node = new LatticeNodeImpl();
        node.setOOV();
        return node;
    }

    protected short posIdOf(Grammar grammar, POS pos, String userPosMode) {
        short posIdPresent = grammar.getPartOfSpeechId(pos);
        if (Objects.equals(userPosMode = userPosMode.toLowerCase(Locale.ROOT), USER_POS_FORBID)) {
            if (posIdPresent >= 0) {
                return posIdPresent;
            }
            throw new IllegalArgumentException(String.format("POS %s WAS NOT present in dictionary and OOV Plugin %s is forbidden to add new POS tags", pos, this));
        }
        if (!Objects.equals(userPosMode, USER_POS_ALLOW)) {
            throw new IllegalArgumentException("Unknown user POS mode: " + userPosMode + " allowed values are: forbid, allow");
        }
        GrammarImpl grammarImpl = (GrammarImpl)grammar;
        return grammarImpl.registerPOS(pos);
    }
}

