/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Config;
import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.POS;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class MeCabOovProviderPlugin
extends OovProviderPlugin {
    Map<CategoryType, CategoryInfo> categories = new EnumMap<CategoryType, CategoryInfo>(CategoryType.class);
    Map<CategoryType, List<OOV>> oovList = new EnumMap<CategoryType, List<OOV>>(CategoryType.class);
    private static final Pattern PATTERN_SPACES = Pattern.compile("\\s+");
    private static final Pattern PATTERN_EMPTY_OR_SPACES = Pattern.compile("\\s*");

    MeCabOovProviderPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) throws IOException {
        Config.Resource charDef = this.settings.getResource("charDef");
        this.readCharacterProperty(charDef);
        Config.Resource unkDef = this.settings.getResource("unkDef");
        this.readOOV(unkDef, grammar, this.settings.getString("userPOS", "forbid"));
    }

    @Override
    public int provideOOV(InputText inputText, int offset, long otherWords, List<LatticeNodeImpl> nodes) {
        int length = inputText.getCharCategoryContinuousLength(offset);
        int added = 0;
        if (length > 0) {
            for (CategoryType type : inputText.getCharCategoryTypes(offset)) {
                int sublength;
                CategoryInfo cinfo = this.categories.get((Object)type);
                if (cinfo == null) continue;
                int llength = length;
                List<OOV> oovs = this.oovList.get((Object)cinfo.type);
                if (oovs == null) continue;
                if (cinfo.isGroup && (cinfo.isInvoke || otherWords == 0L)) {
                    String s = inputText.getSubstring(offset, offset + length);
                    for (OOV oov : oovs) {
                        nodes.add(this.getOOVNode(s, oov, length));
                        ++added;
                    }
                    --llength;
                }
                if (!cinfo.isInvoke && otherWords != 0L) continue;
                for (int i = 1; i <= cinfo.length && (sublength = inputText.getCodePointsOffsetLength(offset, i)) <= llength; ++i) {
                    String s = inputText.getSubstring(offset, offset + sublength);
                    for (OOV oov : oovs) {
                        nodes.add(this.getOOVNode(s, oov, sublength));
                        ++added;
                    }
                }
            }
        }
        return added;
    }

    LatticeNodeImpl getOOVNode(String text, OOV oov, int length) {
        LatticeNodeImpl node = this.createNode();
        node.setParameter(oov.leftId, oov.rightId, oov.cost);
        WordInfo info = new WordInfo(text, (short)length, oov.posId, text, text, "");
        node.setWordInfo(info);
        return node;
    }

    <T> void readCharacterProperty(Config.Resource<T> charDef) throws IOException {
        if (charDef == null) {
            charDef = this.settings.base.toResource(Paths.get("char.def", new String[0]));
        }
        try (InputStream input = charDef.asInputStream();
             InputStreamReader isReader = new InputStreamReader(input, StandardCharsets.UTF_8);
             LineNumberReader reader = new LineNumberReader(isReader);){
            String line = reader.readLine();
            while (line != null) {
                if (!(line.startsWith("#") || line.startsWith("0x") || PATTERN_EMPTY_OR_SPACES.matcher(line).matches())) {
                    CategoryType type;
                    String[] cols = PATTERN_SPACES.split(line);
                    if (cols.length < 4) {
                        throw new IllegalArgumentException("invalid format at line " + reader.getLineNumber());
                    }
                    try {
                        type = CategoryType.valueOf(cols[0]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(cols[0] + " is invalid type at line " + reader.getLineNumber(), e);
                    }
                    if (this.categories.containsKey((Object)type)) {
                        throw new IllegalArgumentException(cols[0] + " is already defined at line " + reader.getLineNumber());
                    }
                    CategoryInfo info = new CategoryInfo();
                    info.type = type;
                    info.isInvoke = !cols[1].equals("0");
                    info.isGroup = !cols[2].equals("0");
                    info.length = Integer.parseInt(cols[3]);
                    this.categories.put(type, info);
                }
                line = reader.readLine();
            }
        }
    }

    <T> void readOOV(Config.Resource<T> unkDef, Grammar grammar, String userPosMode) throws IOException {
        if (unkDef == null) {
            unkDef = this.settings.base.toResource(Paths.get("unk.def", new String[0]));
        }
        try (InputStream input = unkDef.asInputStream();
             InputStreamReader isReader = new InputStreamReader(input, StandardCharsets.UTF_8);
             LineNumberReader reader = new LineNumberReader(isReader);){
            String line = reader.readLine();
            while (line != null) {
                CategoryType type;
                String[] cols = line.split(",");
                if (cols.length < 10) {
                    throw new IllegalArgumentException("invalid format at line " + reader.getLineNumber());
                }
                try {
                    type = CategoryType.valueOf(cols[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(cols[0] + " is invalid type at line " + reader.getLineNumber(), e);
                }
                if (!this.categories.containsKey((Object)type)) {
                    throw new IllegalArgumentException(cols[0] + " is undefined at line " + reader.getLineNumber());
                }
                OOV oov = new OOV();
                oov.leftId = Short.parseShort(cols[1]);
                oov.rightId = Short.parseShort(cols[2]);
                oov.cost = Short.parseShort(cols[3]);
                POS pos = new POS(cols[4], cols[5], cols[6], cols[7], cols[8], cols[9]);
                oov.posId = this.posIdOf(grammar, pos, userPosMode);
                this.oovList.computeIfAbsent(type, t -> new ArrayList()).add(oov);
                line = reader.readLine();
            }
        }
    }

    static class OOV {
        short leftId;
        short rightId;
        short cost;
        short posId;

        OOV() {
        }
    }

    static class CategoryInfo {
        CategoryType type;
        boolean isInvoke;
        boolean isGroup;
        int length;

        CategoryInfo() {
        }
    }
}

