/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Config;
import com.worksap.nlp.sudachi.InputTextBuilder;
import com.worksap.nlp.sudachi.InputTextPlugin;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

class DefaultInputTextPlugin
extends InputTextPlugin {
    Config.Resource<InputStream> rewriteDef;
    private Set<Integer> ignoreNormalizeSet = new HashSet<Integer>();
    private Map<Character, Integer> keyLengths = new HashMap<Character, Integer>();
    private Map<String, String> replaceCharMap = new HashMap<String, String>();
    private static final Pattern PATTERN_SPACES = Pattern.compile("\\s+");
    private static final Pattern PATTERN_EMPTY_OR_SPACES = Pattern.compile("\\s*");

    DefaultInputTextPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) throws IOException {
        if (this.rewriteDef == null) {
            this.rewriteDef = this.settings.getResource("rewriteDef");
        }
        try (InputStream is = null;){
            is = this.rewriteDef != null ? this.rewriteDef.consume(Config.Resource::asInputStream) : DefaultInputTextPlugin.class.getClassLoader().getResourceAsStream("rewrite.def");
            if (is == null) {
                throw new IOException("rewriteDef is not defined");
            }
            this.readRewriteLists(is);
        }
    }

    @Override
    public void rewrite(InputTextBuilder builder) {
        int offset = 0;
        int nextOffset = 0;
        String text = builder.getText();
        int i = 0;
        while (i < text.length()) {
            block3: {
                String replace;
                int charLength;
                int original;
                block5: {
                    int lower;
                    block4: {
                        offset += nextOffset;
                        nextOffset = 0;
                        for (int l = Math.min(this.keyLengths.getOrDefault(Character.valueOf(text.charAt(i)), 0), text.length() - i); l > 0; --l) {
                            String replace2 = this.replaceCharMap.get(text.substring(i, i + l));
                            if (replace2 == null) continue;
                            builder.replace(i + offset, i + l + offset, replace2);
                            nextOffset += replace2.length() - l;
                            i += l - 1;
                            break block3;
                        }
                        original = text.codePointAt(i);
                        charLength = text.offsetByCodePoints(i, 1) - i;
                        lower = Character.toLowerCase(original);
                        if (!this.ignoreNormalizeSet.contains(lower)) break block4;
                        if (original == lower) break block3;
                        replace = new String(Character.toChars(lower));
                        break block5;
                    }
                    replace = Normalizer.normalize(new String(Character.toChars(lower)), Normalizer.Form.NFKC);
                }
                nextOffset = replace.length() - charLength;
                if (replace.length() != charLength || original != replace.codePointAt(0)) {
                    builder.replace(i + offset, i + charLength + offset, replace);
                }
            }
            i = text.offsetByCodePoints(i, 1);
        }
    }

    private void readRewriteLists(InputStream rewriteDef) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(rewriteDef, StandardCharsets.UTF_8);
             LineNumberReader reader = new LineNumberReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || PATTERN_EMPTY_OR_SPACES.matcher(line).matches()) continue;
                String[] cols = PATTERN_SPACES.split(line);
                if (cols.length == 1) {
                    String key = cols[0];
                    if (key.codePointCount(0, key.length()) != 1) {
                        throw new IllegalArgumentException(cols[0] + " is not a character at line " + reader.getLineNumber());
                    }
                    this.ignoreNormalizeSet.add(key.codePointAt(0));
                    continue;
                }
                if (cols.length == 2) {
                    if (this.replaceCharMap.containsKey(cols[0])) {
                        throw new IllegalArgumentException(cols[0] + " is already defined at line " + reader.getLineNumber());
                    }
                    if (this.keyLengths.getOrDefault(Character.valueOf(cols[0].charAt(0)), -1) < cols[0].length()) {
                        this.keyLengths.put(Character.valueOf(cols[0].charAt(0)), cols[0].length());
                    }
                    this.replaceCharMap.put(cols[0], cols[1]);
                    continue;
                }
                throw new IllegalArgumentException("invalid format at line " + reader.getLineNumber());
            }
        }
    }
}

