/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.EditConnectionCostPlugin;
import com.worksap.nlp.sudachi.InputTextPlugin;
import com.worksap.nlp.sudachi.MMap;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.PathAnchor;
import com.worksap.nlp.sudachi.PathRewritePlugin;
import com.worksap.nlp.sudachi.Plugin;
import com.worksap.nlp.sudachi.Settings;
import com.worksap.nlp.sudachi.StringUtil;
import com.worksap.nlp.sudachi.dictionary.BinaryDictionary;
import com.worksap.nlp.sudachi.dictionary.CharacterCategory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;

public class Config {
    private Resource<BinaryDictionary> systemDictionary;
    private List<Resource<BinaryDictionary>> userDictionary;
    private Resource<CharacterCategory> characterDefinition;
    private List<PluginConf<EditConnectionCostPlugin>> editConnectionCost;
    private List<PluginConf<InputTextPlugin>> inputText;
    private List<PluginConf<OovProviderPlugin>> oovProviders;
    private List<PluginConf<PathRewritePlugin>> pathRewrite;
    private Boolean allowEmptyMorpheme;
    private PathAnchor anchor;

    private Config(PathAnchor anchor) {
        this.anchor = anchor;
    }

    public static Config empty() {
        return new Config(PathAnchor.none());
    }

    public static Config defaultConfig() throws IOException {
        return Config.defaultConfig(PathAnchor.classpath());
    }

    public static Config defaultConfig(PathAnchor anchor) throws IOException {
        return Config.fromClasspath("sudachi.json", anchor);
    }

    public static Config fromClasspath(String name) throws IOException {
        return Config.fromClasspath(name, PathAnchor.classpath());
    }

    public static Config fromClasspath(String name, PathAnchor anchor) throws IOException {
        ClassLoader loader = Config.class.getClassLoader();
        PathAnchor newAnchor = anchor.andThen(PathAnchor.classpath(loader));
        URL resource = loader.getResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("failed to find resource in classpath: " + name);
        }
        return Config.fromClasspath(resource, newAnchor);
    }

    public static Config fromClasspath(URL resource) throws IOException {
        return Config.fromClasspath(resource, PathAnchor.classpath());
    }

    public static Config fromClasspath(URL resource, PathAnchor anchor) throws IOException {
        Settings settings = Settings.fromClasspath(resource, anchor);
        return Config.fromSettings(settings);
    }

    public static Config fromFile(Path path) throws IOException {
        return Config.fromSettings(Settings.fromFile(path));
    }

    public static Config fromFile(Path path, PathAnchor anchor) throws IOException {
        return Config.fromSettings(Settings.fromFile(path, anchor));
    }

    public static Config fromJsonString(String json, PathAnchor anchor) {
        return Config.fromSettings(Settings.parse(json, anchor));
    }

    public static Config fromSettings(Settings obj) {
        return Config.empty().fallbackSettings(obj);
    }

    public static Config fromClasspathMerged(String name) throws IOException {
        return Config.fromClasspathMerged(Config.class.getClassLoader(), name);
    }

    public static Config fromClasspathMerged(ClassLoader classLoader, String name) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(name);
        Config result = Config.empty();
        long count = 0L;
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            result = result.withFallback(Config.fromClasspath(resource));
            ++count;
        }
        if (count == 0L) {
            throw new IllegalArgumentException(String.format("couldn't find any file %s in classpath", name));
        }
        return result;
    }

    private static <T> List<T> mergeList(List<T> self, List<T> other) {
        if (self == null) {
            return other;
        }
        return self;
    }

    private static <T extends Plugin> List<PluginConf<T>> mergePluginList(List<PluginConf<T>> self, List<PluginConf<T>> other) {
        if (other != null) {
            if (self == null) {
                return other;
            }
            for (PluginConf<T> selfConf : self) {
                Optional<PluginConf> first = other.stream().filter(p -> Objects.equals(p.clazzName, selfConf.clazzName)).findFirst();
                if (!first.isPresent()) continue;
                PluginConf otherConf = first.get();
                selfConf.internal = selfConf.internal.withFallback(otherConf.internal);
            }
        }
        return self;
    }

    private static <T> T mergeOne(T self, T other) {
        if (self == null) {
            return other;
        }
        return self;
    }

    private Config fallbackSettings(Settings settings) {
        this.systemDictionary = settings.getResource("systemDict");
        this.characterDefinition = settings.getResource("characterDefinitionFile");
        this.userDictionary = settings.getResourceList("userDict");
        this.editConnectionCost = settings.getPlugins("editConnectionCostPlugin", EditConnectionCostPlugin.class);
        this.inputText = settings.getPlugins("inputTextPlugin", InputTextPlugin.class);
        this.oovProviders = settings.getPlugins("oovProviderPlugin", OovProviderPlugin.class);
        this.pathRewrite = settings.getPlugins("pathRewritePlugin", PathRewritePlugin.class);
        this.allowEmptyMorpheme = settings.getBoolean("allowEmptyMorpheme", null);
        this.anchor = this.anchor.andThen(settings.base);
        return this;
    }

    public Config systemDictionary(Path path) {
        this.systemDictionary = new Resource.Filesystem<BinaryDictionary>(path);
        return this;
    }

    public Config systemDictionary(URL url) {
        this.systemDictionary = new Resource.Classpath<BinaryDictionary>(url);
        return this;
    }

    public Config systemDictionary(BinaryDictionary dic) {
        if (!dic.getDictionaryHeader().isSystemDictionary()) {
            throw new IllegalArgumentException("built dictionary must be system");
        }
        this.systemDictionary = new Resource.Ready<BinaryDictionary>(dic);
        return this;
    }

    public Config clearUserDictionaries() {
        if (this.userDictionary == null) {
            this.userDictionary = new ArrayList<Resource<BinaryDictionary>>();
        } else {
            this.userDictionary.clear();
        }
        return this;
    }

    public Config addUserDictionary(Path path) {
        if (this.userDictionary == null) {
            this.userDictionary = new ArrayList<Resource<BinaryDictionary>>();
        }
        this.userDictionary.add(new Resource.Filesystem(path));
        return this;
    }

    public Config addUserDictionary(URL url) {
        if (this.userDictionary == null) {
            this.userDictionary = new ArrayList<Resource<BinaryDictionary>>();
        }
        this.userDictionary.add(new Resource.Classpath(url));
        return this;
    }

    public Config addUserDictionary(BinaryDictionary dic) {
        if (!dic.getDictionaryHeader().isUserDictionary()) {
            throw new IllegalArgumentException("built dictionary must be user");
        }
        if (this.userDictionary == null) {
            this.userDictionary = new ArrayList<Resource<BinaryDictionary>>();
        }
        this.userDictionary.add(Resource.ready(dic));
        return this;
    }

    public Config characterDefinition(Path path) {
        this.characterDefinition = new Resource.Filesystem<CharacterCategory>(path);
        return this;
    }

    public Config characterDefinition(URL url) {
        this.characterDefinition = new Resource.Classpath<CharacterCategory>(url);
        return this;
    }

    public Config characterDefinition(CharacterCategory obj) {
        this.characterDefinition = Resource.ready(obj);
        return this;
    }

    public Config allowEmptyMorpheme(boolean allow) {
        this.allowEmptyMorpheme = allow;
        return this;
    }

    public <T extends EditConnectionCostPlugin> PluginConf<EditConnectionCostPlugin> addEditConnectionCostPlugin(Class<T> clz) {
        PluginConf<EditConnectionCostPlugin> conf = PluginConf.make(clz);
        if (this.editConnectionCost == null) {
            this.editConnectionCost = new ArrayList<PluginConf<EditConnectionCostPlugin>>();
        }
        this.editConnectionCost.add(conf);
        return conf;
    }

    public <T extends InputTextPlugin> PluginConf<InputTextPlugin> addInputTextPlugin(Class<T> clz) {
        PluginConf<InputTextPlugin> conf = PluginConf.make(clz);
        if (this.inputText == null) {
            this.inputText = new ArrayList<PluginConf<InputTextPlugin>>();
        }
        this.inputText.add(conf);
        return conf;
    }

    public <T extends OovProviderPlugin> PluginConf<OovProviderPlugin> addOovProviderPlugin(Class<T> clz) {
        PluginConf<OovProviderPlugin> conf = PluginConf.make(clz);
        if (this.oovProviders == null) {
            this.oovProviders = new ArrayList<PluginConf<OovProviderPlugin>>();
        }
        this.oovProviders.add(conf);
        return conf;
    }

    public Resource<BinaryDictionary> getSystemDictionary() {
        return this.systemDictionary;
    }

    public List<Resource<BinaryDictionary>> getUserDictionaries() {
        return this.userDictionary == null ? Collections.emptyList() : Collections.unmodifiableList(this.userDictionary);
    }

    public Resource<CharacterCategory> getCharacterDefinition() {
        return this.characterDefinition;
    }

    public List<PluginConf<EditConnectionCostPlugin>> getEditConnectionCostPlugins() {
        return this.editConnectionCost == null ? Collections.emptyList() : Collections.unmodifiableList(this.editConnectionCost);
    }

    public List<PluginConf<InputTextPlugin>> getInputTextPlugins() {
        return this.inputText == null ? Collections.emptyList() : Collections.unmodifiableList(this.inputText);
    }

    public List<PluginConf<OovProviderPlugin>> getOovProviderPlugins() {
        return this.oovProviders == null ? Collections.emptyList() : Collections.unmodifiableList(this.oovProviders);
    }

    public List<PluginConf<PathRewritePlugin>> getPathRewritePlugins() {
        return this.pathRewrite == null ? Collections.emptyList() : Collections.unmodifiableList(this.pathRewrite);
    }

    public boolean isAllowEmptyMorpheme() {
        return this.allowEmptyMorpheme == null || this.allowEmptyMorpheme != false;
    }

    public Config withFallback(Config other) {
        this.systemDictionary = Config.mergeOne(this.systemDictionary, other.systemDictionary);
        this.userDictionary = Config.mergeList(this.userDictionary, other.userDictionary);
        this.characterDefinition = Config.mergeOne(this.characterDefinition, other.characterDefinition);
        this.editConnectionCost = Config.mergePluginList(this.editConnectionCost, other.editConnectionCost);
        this.inputText = Config.mergePluginList(this.inputText, other.inputText);
        this.oovProviders = Config.mergePluginList(this.oovProviders, other.oovProviders);
        this.pathRewrite = Config.mergePluginList(this.pathRewrite, other.pathRewrite);
        this.allowEmptyMorpheme = Config.mergeOne(this.allowEmptyMorpheme, other.allowEmptyMorpheme);
        this.anchor = this.anchor.andThen(other.anchor);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return Objects.equals(this.systemDictionary, config.systemDictionary) && Objects.equals(this.userDictionary, config.userDictionary) && Objects.equals(this.characterDefinition, config.characterDefinition) && Objects.equals(this.editConnectionCost, config.editConnectionCost) && Objects.equals(this.inputText, config.inputText) && Objects.equals(this.oovProviders, config.oovProviders) && Objects.equals(this.pathRewrite, config.pathRewrite) && Objects.equals(this.allowEmptyMorpheme, config.allowEmptyMorpheme) && Objects.equals(this.anchor, config.anchor);
    }

    public int hashCode() {
        return Objects.hash(this.systemDictionary, this.userDictionary, this.characterDefinition, this.editConnectionCost, this.inputText, this.oovProviders, this.pathRewrite, this.allowEmptyMorpheme, this.anchor);
    }

    public PathAnchor getAnchor() {
        return this.anchor;
    }

    public Config anchoredWith(PathAnchor anchor) {
        this.anchor = this.anchor.andThen(anchor);
        return this;
    }

    public static abstract class Resource<T> {
        public T consume(IOFunction<Resource<T>, T> creator) throws IOException {
            return creator.apply(this);
        }

        public InputStream asInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer asByteBuffer() throws IOException {
            throw new UnsupportedOperationException();
        }

        Object repr() {
            return null;
        }

        public static <T> Resource<T> ready(T object) {
            return new Ready<T>(object);
        }

        public static class NotFound<T>
        extends Resource<T> {
            private final Path path;
            private final PathAnchor anchor;

            public NotFound(Path path, PathAnchor anchor) {
                this.path = path;
                this.anchor = anchor;
            }

            @Override
            public T consume(IOFunction<Resource<T>, T> creator) throws IOException {
                throw this.makeException();
            }

            @Override
            public InputStream asInputStream() {
                throw this.makeException();
            }

            @Override
            public ByteBuffer asByteBuffer() {
                throw this.makeException();
            }

            @Override
            Object repr() {
                return this.path;
            }

            private IllegalArgumentException makeException() {
                String sb = "Failed to resolve file: " + this.path.toString() + "\nTried roots: " + this.anchor;
                return new IllegalArgumentException(sb);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                NotFound notFound = (NotFound)o;
                return Objects.equals(this.path, notFound.path) && Objects.equals(this.anchor, notFound.anchor);
            }

            public int hashCode() {
                return Objects.hash(this.path, this.anchor);
            }
        }

        static class Ready<T>
        extends Resource<T> {
            private final T object;

            public Ready(T object) {
                this.object = object;
            }

            @Override
            public T consume(IOFunction<Resource<T>, T> creator) {
                return this.object;
            }

            @Override
            Object repr() {
                return this.object;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Ready ready = (Ready)o;
                return Objects.equals(this.object, ready.object);
            }

            public int hashCode() {
                return Objects.hash(this.object);
            }
        }

        public static class Classpath<T>
        extends Resource<T> {
            private final URL url;

            Classpath(URL url) {
                this.url = url;
            }

            @Override
            public InputStream asInputStream() throws IOException {
                return this.url.openStream();
            }

            @Override
            public ByteBuffer asByteBuffer() throws IOException {
                if (Objects.equals(this.url.getProtocol(), "file")) {
                    return MMap.map(this.url.getPath());
                }
                return StringUtil.readAllBytes(this.url);
            }

            public String toString() {
                return this.url.toString();
            }

            @Override
            Object repr() {
                return this.url;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Classpath classpath = (Classpath)o;
                return Objects.equals(this.url, classpath.url);
            }

            public int hashCode() {
                return Objects.hash(this.url);
            }
        }

        public static class Filesystem<T>
        extends Resource<T> {
            private final Path path;

            Filesystem(Path path) {
                this.path = path;
            }

            @Override
            public InputStream asInputStream() throws IOException {
                return Files.newInputStream(this.path, new OpenOption[0]);
            }

            @Override
            public ByteBuffer asByteBuffer() throws IOException {
                return MMap.map(this.path.toString());
            }

            public String toString() {
                return this.path.toString();
            }

            @Override
            Object repr() {
                return this.path;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Filesystem that = (Filesystem)o;
                return this.path.equals(that.path);
            }

            public int hashCode() {
                return Objects.hash(this.path);
            }
        }
    }

    public static class PluginConf<T extends Plugin> {
        String clazzName;
        Settings internal;
        Class<T> parent;

        private PluginConf() {
        }

        PluginConf(String clazzName, Settings internal, Class<T> parent) {
            this.clazzName = clazzName;
            this.internal = internal;
            this.parent = parent;
        }

        public static <T extends Plugin> PluginConf<T> make(Class<T> clz) {
            return new PluginConf<T>(clz.getName(), Settings.empty(), clz);
        }

        public T instantiate(PathAnchor anchor) {
            Plugin result;
            Class<T> clz;
            PathAnchor realAnchor = anchor.andThen(this.internal.base);
            try {
                clz = realAnchor.lookupClass(this.clazzName).asSubclass(this.parent);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("non-existent plugin class", e);
            }
            try {
                Constructor<T> constructor = clz.getDeclaredConstructor(new Class[0]);
                result = (Plugin)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            Settings pluginSettings = Settings.empty().withFallback(this.internal);
            pluginSettings.base = realAnchor;
            result.setSettings(pluginSettings);
            return (T)result;
        }

        public PluginConf<T> add(String key, String value) {
            JsonObject obj = Json.createObjectBuilder().add(key, value).build();
            this.internal = new Settings(obj, PathAnchor.none()).withFallback(this.internal);
            return this;
        }

        public PluginConf<T> add(String key, int value) {
            JsonObject obj = Json.createObjectBuilder().add(key, value).build();
            this.internal = new Settings(obj, PathAnchor.none()).withFallback(this.internal);
            return this;
        }

        public PluginConf<T> addList(String key, String ... values) {
            JsonArrayBuilder builder = Json.createArrayBuilder(Arrays.asList(values));
            JsonObject obj = Json.createObjectBuilder().add(key, builder).build();
            this.internal = new Settings(obj, PathAnchor.none()).withFallback(this.internal);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginConf that = (PluginConf)o;
            return Objects.equals(this.clazzName, that.clazzName) && Objects.equals(this.internal, that.internal) && Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.clazzName, this.internal, this.parent);
        }

        public String toString() {
            return String.format("Plugin (%s) class: %s", this.parent.getSimpleName(), this.clazzName);
        }
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

