/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.Lexicon;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LexiconSet
implements Lexicon {
    static final int MAX_DICTIONARIES = 16;
    List<Lexicon> lexicons = new ArrayList<Lexicon>();
    List<Short> posOffsets = new ArrayList<Short>();

    public LexiconSet(Lexicon systemLexicon) {
        this.lexicons.add(systemLexicon);
        this.posOffsets.add((short)0);
    }

    public void add(Lexicon lexicon, short posOffset) {
        if (!this.lexicons.contains(lexicon)) {
            this.lexicons.add(lexicon);
            this.posOffsets.add(posOffset);
        }
    }

    public boolean isFull() {
        return this.lexicons.size() >= 16;
    }

    @Override
    public Iterator<int[]> lookup(byte[] text, int offset) {
        if (this.lexicons.size() == 1) {
            return this.lexicons.get(0).lookup(text, offset);
        }
        return new Itr(text, offset);
    }

    @Override
    public int getWordId(String headword, short posId, String readingForm) {
        for (int dictId = 1; dictId < this.lexicons.size(); ++dictId) {
            int wid = this.lexicons.get(dictId).getWordId(headword, posId, readingForm);
            if (wid < 0) continue;
            return this.buildWordId(dictId, wid);
        }
        return this.lexicons.get(0).getWordId(headword, posId, readingForm);
    }

    @Override
    public short getLeftId(int wordId) {
        return this.lexicons.get(this.getDictionaryId(wordId)).getLeftId(this.getWordId(wordId));
    }

    @Override
    public short getRightId(int wordId) {
        return this.lexicons.get(this.getDictionaryId(wordId)).getRightId(this.getWordId(wordId));
    }

    @Override
    public short getCost(int wordId) {
        return this.lexicons.get(this.getDictionaryId(wordId)).getCost(this.getWordId(wordId));
    }

    @Override
    public WordInfo getWordInfo(int wordId) {
        int dictionaryId = this.getDictionaryId(wordId);
        WordInfo wordInfo = this.lexicons.get(dictionaryId).getWordInfo(this.getWordId(wordId));
        short posId = wordInfo.getPOSId();
        if (dictionaryId > 0 && posId >= this.posOffsets.get(1)) {
            wordInfo.setPOSId((short)(wordInfo.getPOSId() - this.posOffsets.get(1) + this.posOffsets.get(dictionaryId)));
        }
        this.convertSplit(wordInfo.getAunitSplit(), dictionaryId);
        this.convertSplit(wordInfo.getBunitSplit(), dictionaryId);
        this.convertSplit(wordInfo.getWordStructure(), dictionaryId);
        return wordInfo;
    }

    @Override
    public int getDictionaryId(int wordId) {
        return wordId >>> 28;
    }

    @Override
    public int size() {
        return this.lexicons.stream().mapToInt(Lexicon::size).sum();
    }

    private int getWordId(int wordId) {
        return 0xFFFFFFF & wordId;
    }

    private int buildWordId(int dictId, int wordId) {
        if (wordId > 0xFFFFFFF) {
            throw new IndexOutOfBoundsException("wordId is too large: " + wordId);
        }
        if (dictId >= this.lexicons.size()) {
            throw new IndexOutOfBoundsException("dictionaryId is too large: " + dictId);
        }
        return dictId << 28 | wordId;
    }

    private void convertSplit(int[] split, int dictionaryId) {
        for (int i = 0; i < split.length; ++i) {
            if (this.getDictionaryId(split[i]) <= 0) continue;
            split[i] = this.buildWordId(dictionaryId, this.getWordId(split[i]));
        }
    }

    private class Itr
    implements Iterator<int[]> {
        byte[] text;
        int offset;
        int dictId;
        Iterator<int[]> iterator;

        Itr(byte[] text, int offset) {
            this.text = text;
            this.offset = offset;
            this.dictId = 1;
            this.iterator = LexiconSet.this.lexicons.get(this.dictId).lookup(text, offset);
        }

        @Override
        public boolean hasNext() {
            while (!this.iterator.hasNext()) {
                if (this.dictId == 0) {
                    return false;
                }
                ++this.dictId;
                if (this.dictId >= LexiconSet.this.lexicons.size()) {
                    this.dictId = 0;
                }
                this.iterator = LexiconSet.this.lexicons.get(this.dictId).lookup(this.text, this.offset);
            }
            return true;
        }

        @Override
        public int[] next() {
            if (this.hasNext()) {
                int[] r = this.iterator.next();
                r[0] = LexiconSet.this.buildWordId(this.dictId, r[0]);
                return r;
            }
            throw new NoSuchElementException();
        }
    }
}

