/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.CharacterCategory;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GrammarImpl
implements Grammar {
    private static final int POS_DEPTH = 6;
    private static final short[] BOS_PARAMETER = new short[]{0, 0, 0};
    private static final short[] EOS_PARAMETER = new short[]{0, 0, 0};
    private final ByteBuffer bytes;
    private List<List<String>> posList;
    private ByteBuffer connectTableBytes;
    private boolean isCopiedConnectTable;
    private int connectTableOffset;
    private final short leftIdSize;
    private final short rightIdSize;
    private CharacterCategory charCategory;
    private int storageSize;

    public GrammarImpl(ByteBuffer bytes, int offset) {
        int originalOffset = offset;
        this.bytes = bytes;
        this.connectTableBytes = bytes;
        this.isCopiedConnectTable = false;
        int posSize = bytes.getShort(offset);
        offset += 2;
        this.posList = new ArrayList<List<String>>(posSize);
        for (int i = 0; i < posSize; ++i) {
            ArrayList<String> pos = new ArrayList<String>(6);
            for (int j = 0; j < 6; ++j) {
                pos.add(this.bufferToString(offset));
                offset += 1 + 2 * ((String)pos.get(j)).length();
            }
            this.posList.add(Collections.unmodifiableList(pos));
        }
        this.leftIdSize = bytes.getShort(offset);
        this.rightIdSize = bytes.getShort(offset += 2);
        this.connectTableOffset = offset += 2;
        this.storageSize = offset - originalOffset + 2 * this.leftIdSize * this.rightIdSize;
    }

    public GrammarImpl() {
        this.bytes = ByteBuffer.allocate(0);
        this.posList = Collections.emptyList();
        this.rightIdSize = 0;
        this.leftIdSize = 0;
    }

    public int storageSize() {
        return this.storageSize;
    }

    public void addPosList(GrammarImpl grammar) {
        this.posList.addAll(grammar.posList);
    }

    @Override
    public int getPartOfSpeechSize() {
        return this.posList.size();
    }

    @Override
    public List<String> getPartOfSpeechString(short posId) {
        return this.posList.get(posId);
    }

    @Override
    public short getPartOfSpeechId(List<String> pos) {
        return (short)this.posList.indexOf(pos);
    }

    @Override
    public short getConnectCost(short left, short right) {
        return this.connectTableBytes.getShort(this.connectTableOffset + left * 2 + 2 * this.leftIdSize * right);
    }

    @Override
    public void setConnectCost(short left, short right, short cost) {
        if (!this.isCopiedConnectTable) {
            this.copyConnectTable();
        }
        this.connectTableBytes.putShort(this.connectTableOffset + left * 2 + 2 * this.leftIdSize * right, cost);
    }

    @Override
    public short[] getBOSParameter() {
        return BOS_PARAMETER;
    }

    @Override
    public short[] getEOSParameter() {
        return EOS_PARAMETER;
    }

    @Override
    public CharacterCategory getCharacterCategory() {
        return this.charCategory;
    }

    @Override
    public void setCharacterCategory(CharacterCategory charCategory) {
        this.charCategory = charCategory;
    }

    private String bufferToString(int offset) {
        int length = Byte.toUnsignedInt(this.bytes.get(offset++));
        char[] str = new char[length];
        for (int i = 0; i < length; ++i) {
            str[i] = this.bytes.getChar(offset + 2 * i);
        }
        return new String(str);
    }

    private synchronized void copyConnectTable() {
        ByteBuffer srcBuffer;
        ByteBuffer newBuffer = ByteBuffer.allocate(2 * this.leftIdSize * this.rightIdSize);
        newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer buffer = srcBuffer = this.connectTableBytes.duplicate();
        ((Buffer)buffer).position(this.connectTableOffset);
        ((Buffer)buffer).limit(this.connectTableOffset + 2 * this.leftIdSize * this.rightIdSize);
        newBuffer.put(srcBuffer);
        this.connectTableBytes = newBuffer;
        this.connectTableOffset = 0;
        this.isCopiedConnectTable = true;
    }
}

